% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allClasses.R
\name{createanClique}
\alias{createanClique}
\title{'createanClique' generic function to create an object of class 'anClique'.}
\usage{
createanClique(mzData)
}
\arguments{
\item{mzData}{An object with processed m/z data. See methods for
valid class types.}
}
\description{
\code{anClique} creates an 'anClique' object from processed m/z data.
}
\examples{
\donttest{
library(cliqueMS)
mzfile <- system.file("standards.mzXML", package = "cliqueMS")
rawMS <- MSnbase::readMSData(files = mzfile, mode = "onDisk")
cpw <- xcms::CentWaveParam(ppm = 15, peakwidth = c(5,20), snthresh = 10)
msnExp <- xcms::findChromPeaks(rawMS, cpw)
ex.anClique <- createanClique(msnExp = msnExp)
summary(ex.anClique)
}
}
\seealso{
\code{\link{anClique-class}}
}
