% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{date-sequence}
\alias{date-sequence}
\alias{date_seq.Date}
\title{Sequences: date}
\usage{
\method{date_seq}{Date}(from, ..., to = NULL, by = NULL, total_size = NULL, invalid = NULL)
}
\arguments{
\item{from}{\verb{[Date(1)]}

A date to start the sequence from.

\code{from} is always included in the result.}

\item{...}{These dots are for future extensions and must be empty.}

\item{to}{\verb{[Date(1) / NULL]}

A date to stop the sequence at.

\code{to} is only included in the result if the resulting sequence divides
the distance between \code{from} and \code{to} exactly.

If \code{to} is supplied along with \code{by}, all components of \code{to} more precise
than the precision of \code{by} must match \code{from} exactly. For example, if \code{by = duration_months(1)}, the day component of \code{to} must match the day component
of \code{from}. This ensures that the generated sequence is, at a minimum, a
weakly monotonic sequence of dates.}

\item{by}{\verb{[integer(1) / clock_duration(1) / NULL]}

The unit to increment the sequence by.

If \code{to < from}, then \code{by} must be positive.

If \code{to > from}, then \code{by} must be negative.

If \code{by} is an integer, it is equivalent to \code{duration_days(by)}.

If \code{by} is a duration, it is allowed to have a precision of:
\itemize{
\item year
\item quarter
\item month
\item week
\item day
}}

\item{total_size}{\verb{[positive integer(1) / NULL]}

The size of the resulting sequence.

If specified alongside \code{to}, this must generate a non-fractional sequence
between \code{from} and \code{to}.}

\item{invalid}{\verb{[character(1) / NULL]}

One of the following invalid date resolution strategies:
\itemize{
\item \code{"previous"}: The previous valid instant in time.
\item \code{"previous-day"}: The previous valid day in time, keeping the time of
day.
\item \code{"next"}: The next valid instant in time.
\item \code{"next-day"}: The next valid day in time, keeping the time of day.
\item \code{"overflow"}: Overflow by the number of days that the input is invalid
by. Time of day is dropped.
\item \code{"overflow-day"}: Overflow by the number of days that the input is
invalid by. Time of day is kept.
\item \code{"NA"}: Replace invalid dates with \code{NA}.
\item \code{"error"}: Error on invalid dates.
}

Using either \code{"previous"} or \code{"next"} is generally recommended, as these
two strategies maintain the \emph{relative ordering} between elements of the
input.

If \code{NULL}, defaults to \code{"error"}.

If \code{getOption("clock.strict")} is \code{TRUE}, \code{invalid} must be supplied and
cannot be \code{NULL}. This is a convenient way to make production code robust
to invalid dates.}
}
\value{
A date vector.
}
\description{
This is a Date method for the \code{\link[=date_seq]{date_seq()}} generic.

\code{date_seq()} generates a date (Date) sequence.

When calling \code{date_seq()}, exactly two of the following must be specified:
\itemize{
\item \code{to}
\item \code{by}
\item \code{total_size}
}
}
\examples{
from <- date_build(2019, 1)
to <- date_build(2019, 4)

# Defaults to daily sequence
date_seq(from, to = to, by = 7)

# Use durations to change to monthly or yearly sequences
date_seq(from, to = to, by = duration_months(1))
date_seq(from, by = duration_years(-2), total_size = 3)

# Note that components of `to` more precise than the precision of `by`
# must match `from` exactly. For example, this is not well defined:
from <- date_build(2019, 5, 2)
to <- date_build(2025, 7, 5)
try(date_seq(from, to = to, by = duration_years(1)))

# The month and day components of `to` must match `from`
to <- date_build(2025, 5, 2)
date_seq(from, to = to, by = duration_years(1))

# ---------------------------------------------------------------------------

# Invalid dates must be resolved with the `invalid` argument
from <- date_build(2019, 1, 31)
to <- date_build(2019, 12, 31)

try(date_seq(from, to = to, by = duration_months(1)))
date_seq(from, to = to, by = duration_months(1), invalid = "previous")

# Compare this to the base R result, which is often a source of confusion
seq(from, to = to, by = "1 month")

# This is equivalent to the overflow invalid resolution strategy
date_seq(from, to = to, by = duration_months(1), invalid = "overflow")

# ---------------------------------------------------------------------------

# Usage of `to` and `total_size` must generate a non-fractional sequence
# between `from` and `to`
from <- date_build(2019, 1, 1)
to <- date_build(2019, 1, 4)

# These are fine
date_seq(from, to = to, total_size = 2)
date_seq(from, to = to, total_size = 4)

# But this is not!
try(date_seq(from, to = to, total_size = 3))
}
