% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-day.R
\name{as_year_day}
\alias{as_year_day}
\title{Convert to year-day}
\usage{
as_year_day(x)
}
\arguments{
\item{x}{\verb{[vector]}

A vector to convert to year-day.}
}
\value{
A year-day vector.
}
\description{
\code{as_year_day()} converts a vector to the year-day calendar.
Time points, Dates, POSIXct, and other calendars can all be converted to
year-day.
}
\examples{
# From Date
as_year_day(as.Date("2019-05-01"))

# From POSIXct, which assumes that the naive time is what should be converted
as_year_day(as.POSIXct("2019-05-01 02:30:30", "America/New_York"))

# From other calendars
as_year_day(year_quarter_day(2019, quarter = 2, day = 50))
}
