% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weekday.R
\name{as_weekday}
\alias{as_weekday}
\title{Convert to a weekday}
\usage{
as_weekday(x)
}
\arguments{
\item{x}{\verb{[object]}

An object to convert to a weekday. Usually a sys-time or naive-time.}
}
\value{
A weekday.
}
\description{
\code{as_weekday()} converts to a weekday type. This is normally useful for
converting to a weekday from a sys-time or naive-time. You can use this
function along with the \emph{circular arithmetic} that weekday implements to
easily get to the "next Monday" or "previous Sunday".
}
\examples{
x <- as_naive_time(year_month_day(2019, 01, 05))

# This is a Saturday!
as_weekday(x)

# See the examples in `?weekday` for more usage.
}
