% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-month-weekday.R
\name{year-month-weekday-widen}
\alias{year-month-weekday-widen}
\alias{calendar_widen.clock_year_month_weekday}
\title{Widen: year-month-weekday}
\usage{
\method{calendar_widen}{clock_year_month_weekday}(x, precision)
}
\arguments{
\item{x}{\verb{[clock_year_month_weekday]}

A year-month-weekday vector.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"month"}
\item \code{"day"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
\item \code{"millisecond"}
\item \code{"microsecond"}
\item \code{"nanosecond"}
}}
}
\value{
\code{x} widened to the supplied \code{precision}.
}
\description{
This is a year-month-weekday method for the \code{\link[=calendar_widen]{calendar_widen()}} generic. It
widens a year-month-weekday vector to the specified \code{precision}.
}
\details{
Widening a month precision year-month-weekday to day precision will set
the day and the index to \code{1}. This sets the weekday components to the
first Sunday of the month.
}
\examples{
# Month precision
x <- year_month_weekday(2019, 1)
x

# Widen to day precision
# Note that this sets both the day and index to 1,
# i.e. the first Sunday of the month.
calendar_widen(x, "day")

# Or second precision
sec <- calendar_widen(x, "second")
sec
}
