% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time-entry.R
\name{time_entries}
\alias{time_entries}
\title{Get time entries}
\usage{
time_entries(
  user_id = NULL,
  start = NULL,
  end = NULL,
  description = NULL,
  project_id = NULL,
  task = NULL,
  tags = NULL,
  finished = TRUE,
  concise = TRUE,
  ...
)
}
\arguments{
\item{user_id}{User ID. If not specified then use authenticated user.}

\item{start}{If provided, only time entries that started after the specified datetime will be returned.}

\item{end}{If provided, only time entries that started before the specified datetime will be returned.}

\item{description}{If provided, time entries will be filtered by description.}

\item{project_id}{If provided, time entries will be filtered by project.}

\item{task}{If provided, time entries will be filtered by task.}

\item{tags}{If provided, time entries will be filtered by tags. You can provide one or more tags.}

\item{finished}{Whether to include only finished time intervals (intervals with both start and end time).}

\item{concise}{Generate concise output}

\item{...}{Further arguments passed to \code{\link{paginate}}.}
}
\value{
A data frame with one record per time entry.
}
\description{
You send time according to your account's timezone (from Profile Settings) and get response with time in UTC.
}
\examples{
\dontrun{
set_api_key(Sys.getenv("CLOCKIFY_API_KEY"))

USER_ID <- "612b15a4f4c3bf0462192676"

# Specify number of results per page (default: 50).
time_entries(USER_ID, page_size = 200)
# Specify number of pages.
time_entries(USER_ID, pages = 3)
}
}
