% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCitations.R
\name{getCitations}
\alias{getCitations}
\title{Get the DOIs and quantify the contribution of published studies}
\usage{
getCitations(tree, version = "1.4", data_path = FALSE)
}
\arguments{
\item{tree}{A phylogeny obtained from extractTree (see details).}

\item{version}{The desired version of the tree. Default to the most recent
version of the tree. Other versions available are '0.1','1.0','1.2','1.3','1.4' and can be
passed as a character string or as numeric.}

\item{data_path}{Default to \code{FALSE}, it will look for a path containing the bird tree.
If the tree has not been downloaded yet using \code{\link[=get_avesdata_repo]{get_avesdata_repo()}}, it will load the
default tree using \code{\link[utils:data]{utils::data()}} and \code{version} and \code{taxonomy_year} will be ignored??
If the tree has been downloaded using \code{\link[=get_avesdata_repo]{get_avesdata_repo()}}, it will read the tree file
corresponding to the \code{version} and \code{taxonomy_year} provided and load it as a \code{phylo} object.}
}
\value{
A dataframe of the percent of internal nodes supported by a given study, as well
as the DOI of that study. The proportion of taxa in the tree supported by taxonomic
addition only is included in the dataframe.
}
\description{
Standing on the shoulders of giants
}
\details{
Importantly: an internet connection is required for this function to work, as it
relies on Open Tree of Life APIs. The function will determine what proportion of nodes in
your phylogeny (possibly
but not necessarily pruned to a set of study taxa) are supported by each study that goes into
creating the final clootl tree. In any resulting publication, you should always cite the
clootl tree, and
you should also "always" cite all the trees/DOIs that contributed to your phylogeny. That
said, we are well aware of citation and word count limits that plague modern publishing,
and for this reason we quantify the contribution of each study; depending on your phylogeny,
it is very possible that one or two studies contributed the majority of information. Currently,
this function assumes your output tree matches the taxonomy of the corresponding tree on the
OpenTree server. Since the function is actually using the named internal nodes for the API
query, and these should not be lost between tree versions and taxonomies, this should not
matter, but this has not yet been tested.
}
\examples{
\donttest{#pull the taxonomy file out
data(clootl_data)
tax <- clootl_data$taxonomy.files$Year2021
ls(tax)
#subset to species only
# TODO: this step seems no longer necessary, is it??
# tax <- tax[tax$CATEGORY=="species",]

#simulate extracting a tree for a particular family
temp <- tax[tax$FAMILY=="Rhinocryptidae (Tapaculos)",]
spp <- temp$SCI_NAME

#get your tree
prunedTree <- extractTree(species=spp, label_type="scientific",
   taxonomy_year=2021, version="1.4")

#get your citation DF
 yourCitations <- getCitations(tree=prunedTree)}
}
\author{
Eliot Miller, Emily Jane McTavish
}
