/*
 * Decompiled with CFR 0.152.
 */
package rreval;

import java.io.IOException;
import rreval.ConnectionR;
import rreval.Message;
import rreval.ReadException;
import rreval.Verbose;

public class RWriter {
    private static final char ACK_YES = 'y';
    private static final char ACK_NO = 'n';
    ConnectionR con;
    private char[] ackBuffer;

    public RWriter(ConnectionR con) {
        this.con = con;
    }

    public void writeMessage(Message m) throws Exception {
        Verbose.show("RWriter.writeMessage writing");
        char[] typeA = m.type.toString().toCharArray();
        char[] objLenA = this.toPaddedString(m.obj.length(), 32).toCharArray();
        char[] objA = m.obj.toCharArray();
        Verbose.show("RWriter.writeMessage: obj=>" + m.obj + "< " + "len=" + m.obj.length() + "ch array len=" + m.obj.toCharArray().length);
        int nToWrite = typeA.length + objLenA.length + objA.length;
        int nWrit = 0;
        try {
            this.con.write(typeA);
            nWrit += typeA.length;
            this.con.write(objLenA);
            nWrit += objLenA.length;
            this.con.write(objA);
            nWrit += objA.length;
            Verbose.show("RWriter wrote message to R client: m=" + m);
        }
        catch (Exception x) {
            if (nWrit >= nToWrite) {
                throw x;
            }
            Verbose.showStack("Writing junk after ex", x);
            this.con.write(new char[nToWrite - nWrit]);
        }
        Verbose.show("RWriter.writeMessage sent obj awaiting ack");
        char ack = this.readAck();
        Verbose.show("RWriter.writeMessage got ack=" + ack);
    }

    String toPaddedString(int n, int len) {
        String s = Integer.toString(n);
        if (s.length() < len) {
            return String.format("%1$#" + len + "s", s);
        }
        if (s.length() == len) {
            return s;
        }
        throw new RuntimeException("int too long: " + s);
    }

    char readAck() throws ReadException, IOException {
        this.ackBuffer = new char[2];
        if (this.con.read(this.ackBuffer) == 2) {
            return this.ackBuffer[0];
        }
        throw new ReadException("Wrong count reading ack: 2 expected");
    }
}

