/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe;

import com.norbl.cbp.ppe.PPEManager;
import com.norbl.cbp.ppe.gui.InProgressFrame;
import com.norbl.cbp.ppe.gui.MessageDialog;
import com.norbl.cbp.ppe.gui.NetworkManagerFrame;
import com.norbl.util.ExceptionHandler;
import com.norbl.util.gui.GuiMetrics;
import com.norbl.util.gui.SwingDefaults;
import java.awt.EventQueue;

public abstract class PPEApp {
    protected String[] argv;
    protected PPEManager ppeManager;
    NetworkManagerFrame nmFrame;
    private static boolean VERBOSE = false;

    public PPEApp(String[] argv) throws Exception {
        this.argv = argv;
        System.setProperty("org.apache.commons.logging.Log", "com.norbl.util.NearNilLog");
        GuiMetrics.init();
        SwingDefaults.setDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchNetworkManager() {
        try {
            InProgressFrame.showInProgress();
            this.ppeManager = this.createPPEManager();
            this.ppeManager.setupAWSWrangling();
            this.launchGui();
        }
        catch (Exception xxx) {
            InProgressFrame.end();
            ExceptionHandler.gui(xxx);
        }
        finally {
            InProgressFrame.end();
        }
    }

    protected void launchGui() {
        this.nmFrame = new NetworkManagerFrame(this.ppeManager, this.getTitle());
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    PPEApp.this.nmFrame.startGui();
                    new Thread(){

                        @Override
                        public void run() {
                            PPEManager cfr_ignored_0 = PPEApp.this.ppeManager;
                            if (!PPEManager.paramsEc2.hasRequiredEc2LaunchParams()) {
                                MessageDialog.showNotGoodToGoWarning(PPEApp.this.nmFrame, PPEApp.this.ppeManager);
                            }
                        }
                    }.start();
                }
            });
            InProgressFrame.end();
        }
        catch (Exception xxx) {
            InProgressFrame.end();
            ExceptionHandler.gui(xxx);
        }
    }

    protected abstract PPEManager createPPEManager() throws Exception;

    protected abstract String getTitle();

    public static void verbose(String s) {
        if (VERBOSE) {
            System.out.println(s);
        }
    }

    public static void verbose(Throwable s) {
        if (VERBOSE) {
            System.out.println(s);
        }
    }
}

