/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe;

import com.norbl.cbp.ppe.InstanceStatus;
import com.norbl.cbp.ppe.NetworkInfo;
import com.norbl.cbp.ppe.NiM;
import com.norbl.cbp.ppe.NoSuchNetworkException;
import com.norbl.util.ssh.Ssh;
import com.norbl.util.ssh.SshPingFailureException;
import java.util.ArrayList;
import java.util.List;

public class Pinger {
    public List<InstanceStatus> successes;
    public List<InstanceStatus> failures;
    long maxWait;
    int n;

    public Pinger(long maxWait) {
        this.maxWait = maxWait;
    }

    public void pingNetwork(List<InstanceStatus> instances) {
        this.n = instances.size();
        ArrayList<PingInstance> pingers = new ArrayList<PingInstance>();
        for (InstanceStatus ins : instances) {
            PingInstance pi = new PingInstance(ins);
            pingers.add(pi);
            new Thread(pi).start();
        }
        while (!this.allDone(pingers)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ix) {}
        }
        this.successes = new ArrayList<InstanceStatus>();
        this.failures = new ArrayList<InstanceStatus>();
        for (PingInstance pi : pingers) {
            if (pi.successful) {
                this.successes.add(pi.ins);
                continue;
            }
            this.failures.add(pi.ins);
        }
    }

    public boolean allSucceeded() {
        return this.successes.size() == this.n;
    }

    public String failureNamesToHtmlLines() {
        if (this.failures == null || this.failures.size() < 1) {
            return " ";
        }
        StringBuilder s = new StringBuilder();
        for (InstanceStatus f : this.failures) {
            s.append(f.getPublicDnsName() + "<br>");
        }
        return s.toString();
    }

    private boolean allDone(List<PingInstance> pingers) {
        for (PingInstance pi : pingers) {
            if (pi.done) continue;
            return false;
        }
        return true;
    }

    public static Pinger pingNetwork(String networkID, long maxWait) throws NoSuchNetworkException {
        NetworkInfo ni = NiM.getForID(networkID);
        if (ni == null) {
            throw new NoSuchNetworkException("Network ID=" + networkID + " was not found.");
        }
        List<InstanceStatus> instances = ni.instances;
        Pinger pinger = new Pinger(maxWait);
        pinger.pingNetwork(instances);
        return pinger;
    }

    public static void waitForPingsFromAllHosts(String networkID, long maxWaitMillis) throws NoSuchNetworkException, SshPingFailureException {
        NetworkInfo ni = NiM.getForID(networkID);
        if (ni == null) {
            throw new NoSuchNetworkException("Network ID=" + networkID + " was not found.");
        }
        List<InstanceStatus> instances = ni.instances;
        for (int i = 0; i < instances.size(); ++i) {
            Pinger.waitForPingSsh(instances.get(i).getPublicDnsName(), maxWaitMillis);
        }
    }

    public static void waitForPingSsh(String host, long maxWaitMillis) throws SshPingFailureException {
        long t0 = System.currentTimeMillis();
        while (System.currentTimeMillis() - t0 <= maxWaitMillis) {
            if (Ssh.pingSsh(host)) {
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ix) {}
        }
        throw new SshPingFailureException("Util.waitForPingSsh() timed out attempting to  reach " + host);
    }

    class PingInstance
    implements Runnable {
        InstanceStatus ins;
        String hostName;
        boolean done;
        boolean successful;

        PingInstance(InstanceStatus ins) {
            this.ins = ins;
            this.hostName = ins.getPublicDnsName();
            this.successful = false;
            this.done = false;
        }

        @Override
        public void run() {
            long tm0 = System.currentTimeMillis();
            while (System.currentTimeMillis() - tm0 <= Pinger.this.maxWait) {
                if (Ssh.pingSsh(this.hostName)) {
                    this.successful = true;
                    this.done = true;
                    return;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.done = true;
            this.successful = false;
        }
    }
}

