/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.cbp.ppe.ompi;

import ch.ethz.ssh2.Connection;
import com.norbl.cbp.ppe.ConstantsEc2;
import com.norbl.cbp.ppe.ConstantsPPE;
import com.norbl.cbp.ppe.Ec2Wrangler;
import com.norbl.cbp.ppe.NetworkInfo;
import com.norbl.cbp.ppe.NetworkSpec;
import com.norbl.cbp.ppe.NiM;
import com.norbl.cbp.ppe.PPEApp;
import com.norbl.cbp.ppe.ParamsEc2;
import com.norbl.cbp.ppe.ompi.ConstantsOmpi;
import com.norbl.util.FileUtil;
import com.norbl.util.SshCp;
import com.norbl.util.SysProp;
import com.norbl.util.gui.GuiUtil;
import com.norbl.util.ssh.ConstantsSSH;
import com.norbl.util.ssh.Ssh;
import com.norbl.util.ssh.SshExec;
import com.norbl.util.ssh.SshPingFailureException;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class OmpiConfigurer {
    static final long SSH_EX_MAX_WAIT = 30000L;
    static final String NODE_SHELL_SCRIPT_DIR = "/home/apps";
    Ec2Wrangler ec2w;
    NetworkSpec spec;
    ParamsEc2 paramsEc2;
    String networkID;
    HashMap<String, Connection> connectionHt;
    List<String> hosts;
    String master;
    List<String> slaves;
    State state;
    String stateMessage;
    boolean ompiHostFileInstalled = false;
    File localWorkingDir;
    File localTmpDir;

    public OmpiConfigurer(Ec2Wrangler ec2w, NetworkSpec spec, ParamsEc2 paramsEc2) {
        this.ec2w = ec2w;
        this.spec = spec;
        this.paramsEc2 = paramsEc2;
        this.state = State.nil;
        this.localWorkingDir = new File(SysProp.user_home.getVal(), ".ompi_tmp_dir");
        if (!this.localWorkingDir.exists() || !this.localWorkingDir.isDirectory()) {
            this.localWorkingDir.mkdirs();
            this.localWorkingDir.deleteOnExit();
        }
        this.localTmpDir = new File(this.localWorkingDir, "tmp");
        if (!this.localTmpDir.exists() || !this.localTmpDir.isDirectory()) {
            this.localTmpDir.mkdirs();
            this.localTmpDir.deleteOnExit();
        }
    }

    public boolean isPending() {
        return !State.configuring.equals((Object)this.state) && !State.nil.equals((Object)this.state);
    }

    public boolean isConfigured() {
        return State.configured.equals((Object)this.state) || State.partiallyConfigured.equals((Object)this.state);
    }

    public String getName() {
        return "open-mpi";
    }

    public String getStateDescription() {
        return this.state.toString();
    }

    public boolean config(String networkID) {
        this.setState(State.configuring);
        this.setNetworkID(networkID);
        if (!this.connectToNodes()) {
            this.setState(State.failed, "Failed to connect to nodes");
            return false;
        }
        PPEApp.verbose("OmpiConfigurer: connected to nodes");
        this.ompiHostFileInstalled = this.createAndUploadOmpiHostFile();
        if (!this.ompiHostFileInstalled) {
            this.setState(State.failed, "Failed to install ompi host file");
            return false;
        }
        PPEApp.verbose("OmpiConfigurer: ompi host file installed.");
        String masterNodeScript = this.buildMasterNodeShellScript();
        try {
            PPEApp.verbose("master node script:\n" + masterNodeScript);
            this.execScript(this.master, masterNodeScript, true);
        }
        catch (Exception xxx) {
            PPEApp.verbose(xxx);
            this.setState(State.failed, "Exec of the master node shell script failed.");
            return false;
        }
        PPEApp.verbose("OmpiConfigurer: master node configured.");
        if (!this.uploadPublicRSAKeyToSlaves()) {
            this.setState(State.failed, "Failed to install the public RSA key on slave nodes.");
            return false;
        }
        PPEApp.verbose("OmpiConfigurer: public RSA keys installed.");
        int nSlavesConfigured = this.configureSlaveNodes();
        if (this.slaves.size() < 1 || nSlavesConfigured >= this.slaves.size()) {
            this.setState(State.configured);
            return true;
        }
        if (nSlavesConfigured < this.slaves.size()) {
            this.setState(State.failed, nSlavesConfigured + "/" + this.slaves.size() + " slave nodes were configured.");
            return false;
        }
        this.setState(State.failed, "Bad case.");
        return false;
    }

    public void setNetworkID(String networkID) {
        this.networkID = networkID;
    }

    public boolean connectToNodes() {
        try {
            if (this.networkID == null) {
                throw new Exception("The network ID is missing");
            }
            NetworkInfo ni = NiM.getForID(this.networkID);
            this.master = this.ec2w.getMasterPublicDns(ni);
            if (this.master == null) {
                throw new Exception("Can't get the master node's public DNS");
            }
            this.slaves = this.ec2w.getSlavesPublicDns(ni);
            if (this.slaves == null) {
                throw new Exception("Failed to get slave node public URLs ");
            }
            this.hosts = new ArrayList<String>();
            this.hosts.add(this.master);
            this.hosts.addAll(this.slaves);
            this.waitForAllHostsToRespond(this.hosts);
            this.connectionHt = Ssh.connect(this.hosts, ConstantsEc2.EC2_USERNAME, this.paramsEc2.rsaKeyPairFile, 10000L, 600000L);
            if (this.connectionHt.get(this.master) == null) {
                throw new Exception("No connection for the master node " + this.master);
            }
            for (String sl : this.slaves) {
                if (this.connectionHt.get(sl) != null) continue;
                GuiUtil.warning(new String[]{"No connection for node " + sl}, "No connection");
            }
            return true;
        }
        catch (Exception xxx) {
            GuiUtil.exceptionMessage(xxx);
            return false;
        }
    }

    String buildMasterNodeShellScript() {
        StringBuilder s = new StringBuilder();
        s.append("cd " + ConstantsEc2.EC2_USER_SSH_DIR + ";\n");
        s.append("ssh-keygen -t rsa -f " + ConstantsOmpi.PPE_MASTER_KEY_PAIR_FILENAME + " -P '';\n");
        s.append("\n");
        try {
            s.append(this.getHyperThreadDisablingCommands(this.master));
            s.append("\n");
        }
        catch (Exception xxx) {
            PPEApp.verbose(xxx);
        }
        s.append(this.getRsuCommands());
        s.append("\n");
        return s.toString();
    }

    String buildSlaveNodeShellScript(String slave) {
        StringBuilder s = new StringBuilder();
        s.append("cd " + ConstantsEc2.EC2_USER_SSH_DIR + "\n");
        s.append("cat " + this.getPublicKeyFilename() + " >> " + ConstantsOmpi.AUTHORIZED_KEYS_FILENAME + "\n");
        s.append("\n");
        try {
            s.append(this.getHyperThreadDisablingCommands(slave));
            s.append("\n");
        }
        catch (Exception xxx) {
            PPEApp.verbose(xxx);
        }
        return s.toString();
    }

    boolean createAndUploadOmpiHostFile() {
        try {
            File hostFile = this.createHostFile(this.hosts);
            SshCp scp = new SshCp();
            scp.cp(this.connectionHt.get(this.master), ConstantsEc2.EC2_USER_HOME_DIR, hostFile);
            return true;
        }
        catch (Exception xxx) {
            GuiUtil.exceptionMessage(xxx);
            return false;
        }
    }

    boolean uploadPublicRSAKeyToSlaves() {
        try {
            SshCp scp = new SshCp();
            scp.cp(this.connectionHt, this.slaves, this.master, ConstantsEc2.EC2_USER_SSH_DIR, this.getPublicKeyFilename());
            return true;
        }
        catch (Exception xxx) {
            GuiUtil.exceptionMessage(xxx);
            return false;
        }
    }

    String getPublicKeyFilename() {
        return ConstantsOmpi.PPE_MASTER_KEY_PAIR_FILENAME + ".pub";
    }

    String getHyperThreadDisablingCommands(String nodeName) throws Exception {
        Connection con = this.connectionHt.get(nodeName);
        if (con == null) {
            throw new Exception("No connection for " + nodeName);
        }
        SshExec sx = new SshExec(con);
        String cmd = "sudo ls -1d /sys/devices/system/node/node0/cpu[0123456789]*/online";
        String cpuS = sx.execRead(cmd, 30000L);
        if (cpuS == null) {
            throw new Exception("Failed to get  cpu list from " + nodeName);
        }
        String[] cpuLines = cpuS.trim().split("\n");
        if (cpuLines.length < 1) {
            return "";
        }
        cmd = "sudo cat `ls -1d /sys/devices/system/node/node0/cpu[0123456789]*/online`";
        String stateS = sx.execRead(cmd, 30000L);
        if (stateS == null) {
            throw new Exception("Failed to get  cpu state list from " + nodeName);
        }
        String[] stateLines = stateS.trim().split("\n");
        if (stateLines.length < 1) {
            return "";
        }
        if (stateLines.length != cpuLines.length) {
            throw new Exception("cpu/state count mismatch.");
        }
        int nDisableable = this.countDisableable(stateLines);
        int nCores = this.spec.slotsPerHost;
        if (nCores < 1) {
            return "";
        }
        int nToDisable = nDisableable - nCores;
        if (nToDisable < 1) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        int nDisabled = 0;
        for (int i = 0; i < cpuLines.length; ++i) {
            if (!stateLines[i].trim().equals("1")) continue;
            String c = "echo 0 | sudo tee " + cpuLines[i] + "\n";
            s.append(c);
            if (++nDisabled < nToDisable) continue;
            return s.toString();
        }
        return s.toString();
    }

    private int countDisableable(String[] stateLines) {
        int n = 0;
        for (String s : stateLines) {
            if (!s.trim().equals("1")) continue;
            ++n;
        }
        return n;
    }

    public String getRsuCommands() {
        StringBuilder s = new StringBuilder();
        String targPN = ConstantsEc2.RSU_USER_HOME_DIR + "/" + ConstantsOmpi.OMPI_HOSTFILE_NAME;
        s.append("cd /home/apps\n");
        String pre = "[ -e /home/rsu ] && ";
        s.append(pre + "cp " + ConstantsEc2.EC2_USER_HOME_DIR + "/" + ConstantsOmpi.OMPI_HOSTFILE_NAME + " " + targPN + ";\n");
        s.append(pre + "chown rsu " + targPN + "\n");
        s.append(pre + "chgrp rsu " + targPN + "\n");
        s.append(pre + "chmod a+rw " + targPN + "\n");
        s.append("\n");
        String kp = ConstantsEc2.EC2_USER_SSH_DIR + "/" + ConstantsOmpi.PPE_MASTER_KEY_PAIR_FILENAME;
        String targKP = ConstantsEc2.RSU_USER_SSH_DIR + "/" + ConstantsOmpi.PPE_MASTER_KEY_PAIR_FILENAME;
        s.append(pre + "mkdir " + ConstantsEc2.RSU_USER_SSH_DIR + "\n");
        s.append(pre + "chown rsu " + ConstantsEc2.RSU_USER_SSH_DIR + "\n");
        s.append(pre + "chgrp rsu " + ConstantsEc2.RSU_USER_SSH_DIR + "\n");
        s.append(pre + "chmod go-rwx " + ConstantsEc2.RSU_USER_SSH_DIR + "\n");
        s.append(pre + "cp " + kp + " " + ConstantsEc2.RSU_USER_SSH_DIR + "\n");
        s.append(pre + "chown rsu " + targKP + "\n");
        s.append(pre + "chgrp rsu " + targKP + "\n");
        s.append(pre + "chmod go-rw " + targKP + "\n");
        s.append("\n");
        return s.toString();
    }

    void uploadShellScript(String nodeName, String shellScript) throws Exception {
        Connection con = this.connectionHt.get(nodeName);
        if (con == null) {
            throw new Exception("No connection for " + nodeName);
        }
        SshExec sx = new SshExec(con);
    }

    void execScript(String nodeName, String shellScript, boolean asRoot) throws Exception {
        String fn = nodeName + ".sh";
        File localFile = new File(this.localWorkingDir, fn);
        int n = FileUtil.write(localFile, shellScript);
        if (n < 0) {
            throw new Exception("Local write to " + localFile.getPath() + " failed.");
        }
        Connection con = this.connectionHt.get(nodeName);
        if (con == null) {
            throw new Exception("No connection for " + nodeName);
        }
        SshCp scp = new SshCp();
        scp.cp(con, NODE_SHELL_SCRIPT_DIR, localFile);
        scp.download(con, this.localTmpDir.getPath(), "/home/apps/" + fn);
        File ck = new File(this.localTmpDir, fn);
        if (!ck.exists()) {
            throw new Exception("Failed to up load shell  script " + shellScript + " to " + nodeName);
        }
        String cmd = "cd /home/apps; ";
        cmd = asRoot ? cmd + "sudo bash -c 'bash " + fn + "'" : cmd + "bash " + fn;
        PPEApp.verbose(cmd);
        SshExec sx = new SshExec(con);
        String r = sx.execRead(cmd, 30000L);
    }

    private void setState(State state) {
        this.setState(state, null);
    }

    private void setState(State state, String message) {
        this.state = state;
        NiM.fireStateChangeEvent();
        this.stateMessage = message;
    }

    int configureSlaveNodes() {
        ArrayList<SlaveNodeConfigurer> sncs = new ArrayList<SlaveNodeConfigurer>();
        for (String hostName : this.slaves) {
            SlaveNodeConfigurer snc = new SlaveNodeConfigurer(hostName);
            sncs.add(snc);
            new Thread(snc).start();
        }
        PPEApp.verbose("configureSlaveNodes: " + sncs.size() + " threads launched");
        long tmMax = System.currentTimeMillis() + 300000L;
        while (this.getNSlaveNodeConfigurersFinished(sncs) < sncs.size() && System.currentTimeMillis() < tmMax) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ix) {}
        }
        PPEApp.verbose("Configured " + this.getNSlaveNodeConfigurersFinished(sncs) + "/" + sncs.size() + " slave nodes.");
        return this.getNSlaveNodeConfigurersFinished(sncs);
    }

    int getNSlaveNodeConfigurersFinished(List<SlaveNodeConfigurer> sncs) {
        int n = 0;
        for (SlaveNodeConfigurer snc : sncs) {
            if (!snc.done) continue;
            ++n;
        }
        return n;
    }

    private void waitForAllHostsToRespond(List<String> hosts) throws SshPingFailureException {
        ArrayList<String> failures = new ArrayList<String>();
        for (String h : hosts) {
            try {
                Ssh.waitForPingSsh(h, ConstantsSSH.MAX_WAIT_FOR_SSH_PING);
            }
            catch (SshPingFailureException px) {
                failures.add(h);
            }
        }
        if (failures.size() > 0) {
            String s = new String();
            for (String h : failures) {
                s = s + h + " ";
            }
            throw new SshPingFailureException("Failed to contact hosts: " + s.trim());
        }
    }

    private File createHostFile(List<String> hostNames) throws IOException {
        StringBuilder s = new StringBuilder();
        s.append("# " + ConstantsOmpi.OMPI_HOSTFILE_NAME + "\n\n");
        for (String host : hostNames) {
            s.append(host + " slots=" + Integer.toString(this.spec.slotsPerHost) + "\n");
        }
        String txt = s.toString();
        File tmpDir = FileUtil.getTmpDir(ConstantsPPE.TMP_DIR);
        File hostfile = new File(tmpDir, ConstantsOmpi.OMPI_HOSTFILE_NAME);
        FileWriter fw = new FileWriter(hostfile);
        fw.write(txt);
        fw.flush();
        fw.close();
        return hostfile;
    }

    class SlaveNodeConfigurer
    implements Runnable {
        String hostName;
        boolean done = false;
        Exception xxx;

        SlaveNodeConfigurer(String hostName) {
            this.hostName = hostName;
        }

        @Override
        public void run() {
            try {
                String sc = OmpiConfigurer.this.buildSlaveNodeShellScript(this.hostName);
                PPEApp.verbose("Slave node script for " + this.hostName + "\n" + sc + "\n");
                OmpiConfigurer.this.execScript(this.hostName, sc, true);
                this.done = true;
            }
            catch (Exception xx) {
                PPEApp.verbose(xx);
                this.xxx = xx;
                this.done = true;
            }
        }
    }

    public static enum State {
        nil,
        configuring,
        configured,
        partiallyConfigured,
        failed;

    }
}

