/*
 * Decompiled with CFR 0.152.
 */
package com.norbl.util.aws;

import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.AvailabilityZone;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesResult;
import com.amazonaws.services.ec2.model.DescribeRegionsResult;
import com.amazonaws.services.ec2.model.Region;
import com.norbl.cbp.ppe.Ec2Wrangler;
import com.norbl.cbp.ppe.ParamHtPPE;
import com.norbl.cbp.ppe.ParamsEc2;
import java.util.List;

public class Ec2Location {
    public static final String EU = "eu-west-1";
    public static final String SA = "sa-east-1";
    public static final String US_EAST = "us-east-1";
    public static final String AP_NE = "ap-northeast-1";
    public static final String US_WEST_2 = "us-west-2";
    public static final String US_WEST_1 = "us-west-1";
    public static final String AP_SE = "ap-southeast-1";

    public static List<Region> getAllRegions(AmazonEC2Client aec) {
        DescribeRegionsResult rr = aec.describeRegions();
        return rr.getRegions();
    }

    public static Region getRegion(AmazonEC2Client aec, String regionName) {
        List<Region> regions = Ec2Location.getAllRegions(aec);
        for (Region r : regions) {
            if (!r.getRegionName().equals(regionName)) continue;
            return r;
        }
        return null;
    }

    public static boolean isValidAvailablityZone(AmazonEC2Client aec, String zoneName) {
        DescribeAvailabilityZonesResult r = aec.describeAvailabilityZones();
        for (AvailabilityZone z : r.getAvailabilityZones()) {
            if (!z.getZoneName().equals(zoneName)) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] argv) throws Exception {
        ParamHtPPE paramsHt = new ParamHtPPE(new String[0]);
        ParamsEc2 paramsEc2 = new ParamsEc2(paramsHt);
        Ec2Wrangler w = new Ec2Wrangler(paramsEc2, null);
        Region r = Ec2Location.getRegion(w.ec2Client, US_EAST);
        System.out.println(r.getRegionName() + " " + r.toString());
    }
}

