/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.fps.model;

import com.amazonaws.fps.model.Amount;
import com.amazonaws.fps.model.MarketplaceRefundPolicy;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"transactionId", "refundAmount", "callerReference", "callerDescription", "marketplaceRefundPolicy", "overrideIPNURL"})
@XmlRootElement(name="RefundRequest")
public class RefundRequest {
    @XmlElement(name="TransactionId")
    protected String transactionId;
    @XmlElement(name="RefundAmount")
    protected Amount refundAmount;
    @XmlElement(name="CallerReference")
    protected String callerReference;
    @XmlElement(name="CallerDescription")
    protected String callerDescription;
    @XmlElement(name="MarketplaceRefundPolicy", defaultValue="MasterTxnOnly")
    protected MarketplaceRefundPolicy marketplaceRefundPolicy;
    @XmlElement(name="OverrideIPNURL")
    protected String overrideIPNURL;

    public RefundRequest() {
    }

    public RefundRequest(String transactionId, Amount refundAmount, String callerReference, String callerDescription, MarketplaceRefundPolicy marketplaceRefundPolicy, String overrideIPNURL) {
        this.transactionId = transactionId;
        this.refundAmount = refundAmount;
        this.callerReference = callerReference;
        this.callerDescription = callerDescription;
        this.marketplaceRefundPolicy = marketplaceRefundPolicy;
        this.overrideIPNURL = overrideIPNURL;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String value) {
        this.transactionId = value;
    }

    public boolean isSetTransactionId() {
        return this.transactionId != null;
    }

    public Amount getRefundAmount() {
        return this.refundAmount;
    }

    public void setRefundAmount(Amount value) {
        this.refundAmount = value;
    }

    public boolean isSetRefundAmount() {
        return this.refundAmount != null;
    }

    public String getCallerReference() {
        return this.callerReference;
    }

    public void setCallerReference(String value) {
        this.callerReference = value;
    }

    public boolean isSetCallerReference() {
        return this.callerReference != null;
    }

    public String getCallerDescription() {
        return this.callerDescription;
    }

    public void setCallerDescription(String value) {
        this.callerDescription = value;
    }

    public boolean isSetCallerDescription() {
        return this.callerDescription != null;
    }

    public MarketplaceRefundPolicy getMarketplaceRefundPolicy() {
        return this.marketplaceRefundPolicy;
    }

    public void setMarketplaceRefundPolicy(MarketplaceRefundPolicy value) {
        this.marketplaceRefundPolicy = value;
    }

    public boolean isSetMarketplaceRefundPolicy() {
        return this.marketplaceRefundPolicy != null;
    }

    public String getOverrideIPNURL() {
        return this.overrideIPNURL;
    }

    public void setOverrideIPNURL(String value) {
        this.overrideIPNURL = value;
    }

    public boolean isSetOverrideIPNURL() {
        return this.overrideIPNURL != null;
    }

    public RefundRequest withTransactionId(String value) {
        this.setTransactionId(value);
        return this;
    }

    public RefundRequest withRefundAmount(Amount value) {
        this.setRefundAmount(value);
        return this;
    }

    public RefundRequest withCallerReference(String value) {
        this.setCallerReference(value);
        return this;
    }

    public RefundRequest withCallerDescription(String value) {
        this.setCallerDescription(value);
        return this;
    }

    public RefundRequest withMarketplaceRefundPolicy(MarketplaceRefundPolicy value) {
        this.setMarketplaceRefundPolicy(value);
        return this;
    }

    public RefundRequest withOverrideIPNURL(String value) {
        this.setOverrideIPNURL(value);
        return this;
    }

    protected String toJSONFragment() {
        StringBuffer json = new StringBuffer();
        boolean first = true;
        if (this.isSetTransactionId()) {
            if (!first) {
                json.append(", ");
            }
            json.append(this.quoteJSON("TransactionId"));
            json.append(" : ");
            json.append(this.quoteJSON(this.getTransactionId()));
            first = false;
        }
        if (this.isSetRefundAmount()) {
            if (!first) {
                json.append(", ");
            }
            json.append("\"RefundAmount\" : {");
            Amount refundAmount = this.getRefundAmount();
            json.append(refundAmount.toJSONFragment());
            json.append("}");
            first = false;
        }
        if (this.isSetCallerReference()) {
            if (!first) {
                json.append(", ");
            }
            json.append(this.quoteJSON("CallerReference"));
            json.append(" : ");
            json.append(this.quoteJSON(this.getCallerReference()));
            first = false;
        }
        if (this.isSetCallerDescription()) {
            if (!first) {
                json.append(", ");
            }
            json.append(this.quoteJSON("CallerDescription"));
            json.append(" : ");
            json.append(this.quoteJSON(this.getCallerDescription()));
            first = false;
        }
        if (this.isSetMarketplaceRefundPolicy()) {
            if (!first) {
                json.append(", ");
            }
            json.append(this.quoteJSON("MarketplaceRefundPolicy"));
            json.append(" : ");
            json.append(this.quoteJSON(this.getMarketplaceRefundPolicy().value()));
            first = false;
        }
        if (this.isSetOverrideIPNURL()) {
            if (!first) {
                json.append(", ");
            }
            json.append(this.quoteJSON("OverrideIPNURL"));
            json.append(" : ");
            json.append(this.quoteJSON(this.getOverrideIPNURL()));
            first = false;
        }
        return json.toString();
    }

    private String quoteJSON(String string) {
        StringBuffer sb = new StringBuffer();
        sb.append("\"");
        int length = string.length();
        block10: for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                default: {
                    if (c < ' ') {
                        sb.append("\\u" + String.format("%03x", c));
                        continue block10;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append("\"");
        return sb.toString();
    }
}

