% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudml-package.R
\docType{package}
\name{cloudml-package}
\alias{cloudml-package}
\alias{_PACKAGE}
\alias{cloudml}
\title{Interface to the Google Cloud Machine Learning Platform}
\description{
The \strong{cloudml} package provides an R interface to \href{https://cloud.google.com/ml-engine/}{Google Cloud MachineLearning Engine}, a managed service that
enables:
\itemize{
\item Scalable training of models built with the
\href{https://keras.rstudio.com/}{keras},
\href{https://tensorflow.rstudio.com/tfestimators}{tfestimators}, and
\href{https://tensorflow.rstudio.com/}{tensorflow} R packages.
\item On-demand access to training on GPUs, including the new \href{http://www.nvidia.com/object/tesla-p100.html}{Tesla P100GPUs} from NVIDIA®.
\item Hyperparameter tuning to optimize key attributes of model architectures in
order to maximize predictive accuracy.
\item Deployment of trained models to the Google global prediction platform that
can support thousands of users and TBs of data.
}
}
\details{
CloudML is a managed service where you pay only for the hardware resources
that you use. Prices vary depending on configuration (e.g. CPU vs. GPU vs.
multiple GPUs). See \url{https://cloud.google.com/ml-engine/pricing} for
additional details.

For documentation on using the R interface to CloudML see the package website
at \url{https://tensorflow.rstudio.com/tools/cloudml/}
}
\references{
\url{https://tensorflow.rstudio.com/tools/cloudml/}
}
\author{
\strong{Maintainer}: Javier Luraschi \email{javier@rstudio.com}

Authors:
\itemize{
  \item JJ Allaire
  \item Kevin Ushey
}

Other contributors:
\itemize{
  \item  RStudio [copyright holder]
}

}
\keyword{internal}
