% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.ctest}
\alias{print.ctest}
\title{Print Function for Nonparametric Test for Clustered Data}
\usage{
\method{print}{ctest}(x, digits = getOption("digits"), prefix = "\\t", ...)
}
\arguments{
\item{x}{object of class "\code{ctest}".}

\item{digits}{number of significant digits to be used.}

\item{prefix}{string, passed to \link{strwrap}
for displaying the method component of the htest object.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
the argument \code{x}, invisibly, as for all \link{print}
methods.
}
\description{
Printing objects of class "\code{ctest}", by simple \link{print}
methods.
}
\examples{
data(crd)
clt <- cluswilcox.test(z ~ group(group) + cluster(id), data = crd)
print(clt, digits = 2)
}
\author{
Yujing Jiang
}

