% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/clusterIM.R
\name{cluster.im}
\alias{cluster.im}
\title{Cluster-Adjusted Confidence Intervals and p-Values for GLM}
\usage{
cluster.im(mod, dat, cluster, ci.level = 0.95, report = TRUE,
  drop = FALSE)
}
\arguments{
\item{mod}{A model estimated using \code{glm}.}

\item{dat}{The data set used to estimate \code{mod}.}

\item{cluster}{A formula of the clustering variable.}

\item{ci.level}{What confidence level should CIs reflect?}

\item{report}{Should a table of results be printed to the console?}

\item{drop}{Should clusters within which a model cannot be estimated be dropped?}
}
\value{
A list with the elements
\item{p.values}{A matrix of the estimated p-values.}
\item{ci}{A matrix of confidence intervals.}
}
\description{
Computes p-values and confidence intervals for GLM models based on cluster-specific model estimation (Ibragimov and Muller 2010). A separate model is estimated in each cluster, and then p-values and confidence intervals are computed based on a t/normal distribution of the cluster-specific estimates.
}
\note{
Confidence intervals are centered on the cluster averaged estimate, which can diverge from original model estimates if clusters have different numbers of observations. Consequently, confidence intervals may not be centered on original model estimates.
}
\examples{
\dontrun{
# predict whether respondent has a university degree
require(effects)
data(WVS)
logit.model <- glm(degree ~ religion + gender + age, data=WVS, family=binomial(link="logit"))
summary(logit.model)

# compute cluster-adjusted p-values
clust.p <- cluster.im(logit.model, WVS, ~ country, ci.level = 0.95, report = T, drop = FALSE)
}
}
\author{
Justin Esarey
}
\references{
Ibragimov, Rustam, and Ulrich K. Muller. 2010. "t-Statistic Based Correlation and Heterogeneity Robust Inference." \emph{Journal of Business & Economic Statistics} 28(4): 453-468.
}

