% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preProcess.R
\name{preProcess_removeFPCircle}
\alias{preProcess_removeFPCircle}
\title{Given a surface matrix, estimates and filters any pixels within the estimated
firing pin impression circle}
\usage{
preProcess_removeFPCircle(
  x3p,
  aggregationFunction = mean,
  smootherSize = 2 * round((0.1 * nrow(surfaceMat)/2)) + 1,
  gridSize = 40,
  gridGranularity = 1,
  houghScoreQuant = 0.9
)
}
\arguments{
\item{x3p}{an x3p object containing a surface matrix}

\item{aggregationFunction}{function to select initial radius estimate from
those calculated using fpRadiusGridSearch}

\item{smootherSize}{size of average smoother (to be passed to zoo::roll_mean)}

\item{gridSize}{size of grid, centered on the initial radius estimate, to be
used to determine the best fitting circle to the surface matrix via the
Hough transform method}

\item{gridGranularity}{granularity of radius grid used to determine the best
fitting circle to the surface matrix via the Hough transform method}

\item{houghScoreQuant}{quantile cut-off to be used when determining a final
radius estimate using the score values returned by the imager::hough_circle}
}
\value{
An x3p object containing a surface matrix with the estimated firing
pin circle pixels replaced with NAs.
}
\description{
Given a surface matrix, estimates and filters any pixels within the estimated
firing pin impression circle
}
\note{
imager treats a matrix as its transpose (i.e., x and y axes are
swapped). As such, relative to the original surface matrix, the x and y
columns in the data frame fpImpressionCircle actually correspond to the row
and column indices at which the center of the firing pin impression circle
is estiamted to be.
}
\examples{
\dontrun{
nbtrd_link <- "https://tsapps.nist.gov/NRBTD/Studies/CartridgeMeasurement/"
fadul1.1_link <- "DownloadMeasurement/2d9cc51f-6f66-40a0-973a-a9292dbee36d"

fadul1.1 <- x3ptools::read_x3p(paste0(nbtrd_link,fadul1.1_link))

fadul1.1_labelCropped <- fadul1.1 \%>\%
                     preProcess_crop(region = "exterior",
                                     radiusOffset = -30) \%>\%
                     preProcess_crop(region = "interior",
                                     radiusOffset = 200) \%>\%
                     preProcess_removeTrend(statistic = "quantile",
                                            tau = .5,
                                            method = "fn")

fadul1.1_houghCropped <- fadul1.1 \%>\%
                          x3ptools::x3p_sample() \%>\%
                          preProcess_ransacLevel() \%>\%
                          preProcess_crop(region = "exterior",
                                          radiusOffset = -30) \%>\%
                          preProcess_removeFPCircle()

x3pListPlot(list("Original" = fadul1.1,
                 "Cropped by Labeling" = fadul1.1_labelCropped,
                 "Cropped by Hough" = fadul1.1_houghCropped),type = "list")
}
}
