% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decision.R
\name{decision_highCMC_cmcThetaDistrib}
\alias{decision_highCMC_cmcThetaDistrib}
\title{Compute CMC-theta distribution for a set of comparison features}
\usage{
decision_highCMC_cmcThetaDistrib(
  cellIndex,
  x,
  y,
  theta,
  corr,
  xThresh = 20,
  yThresh = xThresh,
  corrThresh = 0.5
)
}
\arguments{
\item{cellIndex}{vector/tibble column containing cell indices corresponding to
a reference cell}

\item{x}{vector/tibble column containing x horizontal translation values}

\item{y}{vector/tibble column containing y vertical translation values}

\item{theta}{vector/tibble column containing theta rotation values}

\item{corr}{vector/tibble column containing correlation similarity scores
between a reference cell and its associated target region}

\item{xThresh}{used to classify particular x values "congruent" (conditional
on a particular theta value) if they are within xThresh of the
theta-specific median x value}

\item{yThresh}{used to classify particular y values "congruent" (conditional
on a particular theta value) if they are within yThresh of the
theta-specific median y value}

\item{corrThresh}{to classify particular correlation values "congruent"
(conditional on a particular theta value) if they are at least corrThresh}
}
\value{
a vector of the same length as the input containing a "CMC Candidate"
or "Non-CMC Candidate" classification based on whether the particular
cellIndex has congruent x,y, and theta features.
}
\description{
Compute CMC-theta distribution for a set of comparison features
}
\note{
This function is a helper internally called in the decision_CMC
function. It is exported to be used as a diagnostic tool for the High CMC
method
}
\examples{
\dontrun{
data(fadul1.1_processed,fadul1.2_processed)

comparisonDF <- purrr::map_dfr(seq(-30,30,by = 3),
                              ~ comparison_allTogether(fadul1.1_processed,
                                                       fadul1.2_processed,
                                                       theta = .))

comparisonDF <- comparisonDF \%>\%
dplyr::mutate(cmcThetaDistribClassif = decision_highCMC_cmcThetaDistrib(cellIndex = cellIndex,
                                                                 x = x,
                                                                 y = y,
                                                                 theta = theta,
                                                                 corr = pairwiseCompCor))

comparisonDF \%>\%
dplyr::filter(cmcThetaDistribClassif == "CMC Candidate") \%>\%
ggplot2::ggplot(ggplot2::aes(x = theta)) +
ggplot2::geom_bar(stat = "count")
}
}
