% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/giniquintile.R
\name{giniquintile}
\alias{giniquintile}
\title{Gini coefficients}
\usage{
giniquintile(L)
}
\arguments{
\item{L}{vector of percentages at 20th, 40th, 60th, and 80th
percentiles}
}
\value{
the estimated Gini coefficient
}
\description{
Calculate the Gini coefficient from quintile data
}
\details{
Calculate the Gini coefficient given the quintile data.
}
\examples{
L <- c(4.3, 9.8, 15.4, 22.7)
giniquintile(L)

}
\references{
Leon Gerber, "A Quintile Rule for the Gini Coefficient",
\emph{Mathematics Magazine}, 80:2, April 2007.
}
\seealso{
Other integration: \code{\link{adaptint}},
  \code{\link{gaussint}}, \code{\link{mcint}},
  \code{\link{midpt}}, \code{\link{revolution-solid}},
  \code{\link{romberg}}, \code{\link{simp38}},
  \code{\link{simp}}, \code{\link{trap}}

Other newton-cotes: \code{\link{adaptint}},
  \code{\link{midpt}}, \code{\link{romberg}},
  \code{\link{simp38}}, \code{\link{simp}},
  \code{\link{trap}}
}
