% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_regular.R
\name{map_regular}
\alias{map_regular}
\title{Grid interpolation.}
\usage{
map_regular(
  var,
  infile,
  auxfile,
  outfile,
  dxy = 0.05,
  dxy_factor = 1,
  method = "nearest",
  nc34 = 4,
  overwrite = FALSE,
  verbose = FALSE,
  nc = NULL
)
}
\arguments{
\item{var}{Name of NetCDF variable (character).}

\item{infile}{Filename of input NetCDF file (irregular gridded). This may include the
directory (character). The data of infile are interpolated.}

\item{auxfile}{Filename auxiliary file. This may include the directory
(character).}

\item{outfile}{Filename of output NetCDF file. This may include the directory
(character).}

\item{dxy}{Grid resolution of the regular output grid in degrees (numeric). Default is 0.05°.}

\item{dxy_factor}{In case of nearest neighbor all grid points with distance > (dxy * dxy_factor)
are set to NA (numeric). Default is 1.}

\item{method}{Method used for remapping (character). Default and so far the only option
is "nearest" for nearest-neighbor interpolation.}

\item{nc34}{NetCDF version of output file. If \code{nc34 = 3} the output file will be
in NetCDFv3 format (numeric). Default output is NetCDFv4.}

\item{overwrite}{logical; should existing output file be overwritten?}

\item{verbose}{logical; if TRUE, progress messages are shown}

\item{nc}{Alternatively to \code{infile} you can specify the input as an
object of class \code{ncdf4} (as returned from \code{ncdf4::nc_open}).}
}
\value{
A NetCDF file including the interpolated data of infile on a regular lon / lat grid
with a spatial resolution of dxy.
}
\description{
The function interpolates the irregular gridded data of infile using grid information
of auxfile. The intention of this function is to remap CLAAS level-2 data onto a
regular gridded lon / lat grid.
By default, a nearest neighbor interpolation provided by
\code{\link[FNN:get.knn]{get.knnx}} is used.
}
\seealso{
Other data manipulation functions: 
\code{\link{acsaf_box_mergetime}()},
\code{\link{add_grid_info}()},
\code{\link{box_mergetime}()},
\code{\link{cmsaf.transform.coordinate.system}()},
\code{\link{levbox_mergetime}()},
\code{\link{remap}()}
}
\concept{data manipulation functions}
