% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumstat_ihh.R
\name{sumstat_ihh}
\alias{sumstat_ihh}
\title{Summary Statistic: Integrated Extended Haplotype Homozygosity}
\usage{
sumstat_ihh(
  name = "ihh",
  population = 1,
  max_snps = 1000,
  calc_ihs = FALSE,
  transformation = identity
)
}
\arguments{
\item{name}{The name of the summary statistic. When simulating a model,
the value of the statistics are written to an entry of the returned list
with this name. Summary statistic names must be unique in a model.}

\item{population}{The population for which the statistic is calculated.
Can also be "all" to calculate it from all populations.}

\item{max_snps}{The maximal number of SNPs per locus that are used for the
calculation. If a locus has more SNPs, only a random subset of them will
be used to increase performance. Set to \code{Inf} to use all SNPs.}

\item{calc_ihs}{If set to \code{TRUE}, additionally standardized iHS is
calculated.}

\item{transformation}{An optional function for transforming the results
of the statistic. If specified, the results of the transformation are
returned instead of the original values.}
}
\value{
If \code{calc_ihs = FALSE}, a data.frame with values for
  iHH and iES is returned. Otherwise, a list of two data frames are
  returned, one for IHH and IES values and the other one for IHS values.

  In all `data.frames` rows are SNPs and the columns present the following
  values for each SNP:
  \itemize{
   \item{CHR: The SNP's locus}
   \item{POSITION: The SNP's absolute position on its locus}
   \item{FREQ_A: The frequency of the ancestral allele}
   \item{FREQ_D: The frequency of the derived allele}
   \item{IHH_A: integrated EHH for the ancestral allele}
   \item{IHH_D: integrated EHH for the derived allele}
   \item{IES: integrated EHHS}
   \item{INES: integrated normalized EHHS}
   \item{IHS: iHS, normalized over all loci.}
  }
}
\description{
This summary statistic calculates a number of values based on
extended haplotype homozygosity (EHH), including iHH, iES
and optionally iHS.
Coala relies on \code{\link[rehh]{scan_hh}} from package \pkg{rehh} to
calculate this statistic. Please refer
to their documentation for detailed information on the implementation.
Please cite the corresponding publication (see below) if you use the
statistic for a publication.
}
\section{References}{

\itemize{
 \item{Mathieu Gautier and Renaud Vitalis, rehh: an R package to detect
      footprints of selection in genome-wide SNP data from
      haplotype structure. Bioinformatics (2012) 28 (8): 1176-1177
      first published online March 7, 2012 doi:10.1093/bioinformatics/bts115}
 \item{Voight et al., A map of recent positive selection in the human
                       genome. PLoS Biol, 4(3):e72, Mar 2006.}
 }
}

\examples{
  model <- coal_model(20, 1, 1000) +
    feat_mutation(1000) +
    sumstat_ihh()
\donttest{
    stat <- simulate(model)
    print(stat$ihh)}
}
\seealso{
To create a demographic model: \code{\link{coal_model}}

To calculate this statistic from data: \code{\link{calc_sumstats_from_data}}

Other summary statistics: 
\code{\link{sumstat_dna}()},
\code{\link{sumstat_file}()},
\code{\link{sumstat_four_gamete}()},
\code{\link{sumstat_jsfs}()},
\code{\link{sumstat_mcmf}()},
\code{\link{sumstat_nucleotide_div}()},
\code{\link{sumstat_omega}()},
\code{\link{sumstat_seg_sites}()},
\code{\link{sumstat_sfs}()},
\code{\link{sumstat_tajimas_d}()},
\code{\link{sumstat_trees}()}
}
\author{
Paul Staab
}
\concept{summary statistics}
