% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prettify.R
\name{prettify_strings}
\alias{prettify_strings}
\alias{prettify_de}
\alias{prettify_en}
\title{Replace/prettify matching words/terms in one vector by another}
\usage{
prettify_strings(
  x,
  current = .trans_df$english,
  new = .trans_df$english_pretty
)

prettify_de(x)

prettify_en(x)
}
\arguments{
\item{x}{A character vector (or factor) that should be renamed.}

\item{current}{A vector of characters (possibly subset of \code{x}).
Entries in \code{x} that match entries in \code{current} will be renamed
according to entries in \code{new}.}

\item{new}{A vector of characters that will replace entries in \code{x} which
have matches in \code{current}.}
}
\description{
The function searches for \code{x} values, that occur in \code{current}
and replaces them with entries in \code{new}. Useful for quick
renaming/translation of survey column names and by using internal object
\code{.trans_df}
}
\examples{
library(coalitions)
library(dplyr)
# look at sample German federal election polls
surveys <- surveys_sample \%>\% tidyr::unnest("surveys") \%>\% group_by(pollster) \%>\% slice(1)
# prettify the polling agency names
prettify_strings(surveys$pollster)
prettify_en(surveys$pollster)
prettify_de(surveys$pollster)
}
\keyword{internal}
