% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batest.R
\name{batest}
\alias{batest}
\alias{print.batest}
\alias{plot.batest}
\title{Bland-Altman Test of Method Agreement}
\usage{
batest(formula, data, subset, na.action, weights, ...)

\method{print}{batest}(x, digits = 2, type = c("test", "model", "both"), ...)

\method{plot}{batest}(x, ...)
}
\arguments{
\item{formula}{symbolic description of the model used to perform the Bland-Altman test of type \code{y1 + y2 ~ x}.
The left-hand side should specify a pair of measurements (\code{y1} and \code{y2}) to assess the agreement.
The right-hand side should specify a factor with two levels indicating two independent groups or samples to be compared. Alternatively, multilevel factors or continuously scaled variables can be specified to perform a Bland-Altman test of association, followed by binary splitting into two subgroups.}

\item{data, subset, na.action}{arguments controlling the formula processing
via \code{\link[stats]{model.frame}}.}

\item{weights}{optional numeric vector of weights (case/frequency weights, by default).}

\item{...}{further control arguments, passed to \code{\link[partykit]{ctree_control}}}

\item{x}{an object as returned by \code{\link[coat]{batest}}.}

\item{digits}{a numeric specifying the number of digits to display.}

\item{type}{character string specifying whether \code{"test"} statistics (default), the \code{"model"} or \code{"both"} should be printed.}
}
\value{
Object of class \code{batest} with elements
\item{\code{test}}{result of the Bland-Altman test.}
\item{\code{model}}{tree model used to perform the Bland-Altman test.}
}
\description{
Function to perform a Bland-Altman test of differences in method agreement. Additional functions are given for printing and plotting.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(batest)}: function to print the result of the Bland-Altman test.

\item \code{plot(batest)}: function to plot the result of the Bland-Altman test.

}}
\examples{
\dontshow{ if(!requireNamespace("MethComp")) {
  if(interactive() || is.na(Sys.getenv("_R_CHECK_PACKAGE_NAME_", NA))) {
    stop("the MethComp package is required for this example but is not installed")
  } else q() }
}
## package and data (reshaped to wide format)
library("coat")
data("VitCap", package = "MethComp")
VitCap_wide <- reshape(VitCap, v.names = "y", timevar = "instrument",
                       idvar = c("item", "user"), drop = "meth", direction = "wide")

## two-sample BA-test
testresult <- batest(y.St + y.Exp ~ user, data = VitCap_wide)

## display
testresult
print(testresult, digits = 1, type = "both")
plot(testresult)

}
