% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_codemeta.R
\name{create_codemeta}
\alias{create_codemeta}
\title{create_codemeta}
\usage{
create_codemeta(pkg = ".", root = ".", id = NULL,
  force_update = getOption("codemeta_force_update", TRUE), ...)
}
\arguments{
\item{pkg}{package path to package root, or package name, or
description file (character), or a codemeta object (list)}

\item{root}{if pkg is a codemeta object, optionally give the path
to package root. Default guess is current dir.}

\item{id}{identifier for the package, e.g. a DOI (or other resolvable URL)}

\item{force_update}{Update guessed fields even if they are defined in an existing codemeta.json file}

\item{...}{additional arguments to \code{\link{write_json}}}
}
\value{
a codemeta list object
}
\description{
create a codemeta list object in R for further manipulation. Similar
to \code{\link{write_codemeta}}, but returns an R list object rather
than writing directly to a file.  See examples.
}
\examples{
cm <- create_codemeta("jsonlite")
cm$keywords <- list("metadata", "ropensci")
}
