% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr-comp.R
\name{ConceptTestSummary}
\alias{ConceptTestSummary}
\title{Summary table on concept comparisons}
\usage{
ConceptTestSummary(project, units, limit.p.value = 0.05)
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{units}{The units to compare}

\item{limit.p.value}{A numeric.}
}
\value{
A data frame
}
\description{
Summary table on concept comparisons
}
\details{
This function produce a summary table based on concept comparisons and is reactive to a limit of p.value beyond which differences are considered as significant and are reported in the table
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

## More documents are needed for running this function
## ConceptTestSummary(my.project, units = c("Belgium", "Québec"), 0.6)
}
