% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr.R
\name{EdgSocCMap}
\alias{EdgSocCMap}
\title{Aggregation of the relationships identified in a serie of Individual Cognitive Maps}
\usage{
EdgSocCMap(
  project,
  min.weight = 1,
  filters = NULL,
  units = "all",
  weighted.icm = FALSE
)
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}

\item{min.weight}{A integer that will determine the minimum (>=) weight of relationships that will be taken into account. Relationships with a lower weight (<) will not be shown. Default is set to 1 (\emph{i.e.} all relationships are shown).}

\item{filters}{A list of named strings that will filter the relationships showed in the SCM. e.g. =list(coding_class = "A_coding_class", document_part = "A_document_part")=. To date, these filters are linked to the nature of relationships.}

\item{units}{A string vector giving the names of the units (i.e. classes linked to documents) that will be include in the SCM. It is a second type of filter.}

\item{weighted.icm}{A boolean. If FALSE, the weight of the relationships in the ICM will be fixed to 1.}
}
\value{
A data frame with four or five variables :
##' \describe{
\item{$edge}{The name of the relationship, of the generic form \emph{x~y}}
\item{$FACTOR}{If used, the factor the parameter \emph{variable}]. This variable contains then the levels of the factor defined in the parameter \emph{group} used as subset criteria}
\item{$weight}{The weight of each relationship}
\item{$from}{The number of the vertex at the origin of the relationship}
\item{$to}{The number of the vertex at the end of the relationship}
}
}
\description{
This function will produce a data frame that contains all relationships of a serie of Individual Cognitive Maps. The weights of these relationships are calculated.
}
\details{
The function can be used to produce a data frame that contains only the relation with a minimum weight or that concerns only a type of agents.
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

EdgSocCMap(my.project)
EdgSocCMap(my.project)
EdgSocCMap(my.project, min.weight=3)
EdgSocCMap(my.project, min.weight=6, weighted.icm=TRUE)
}
