## ---- fig.show='hold', message=FALSE,warning=FALSE-----------------------
library(cohorttools)
library(DiagrammeR)
library(survival)
library(Epi)
library(mstate)
data(ebmt3)
bmt <- Lexis(exit = list(tft = rfstime/365.25),
             exit.status = factor(rfsstat, labels = c("Tx", "RD")),
                          data = ebmt3)
bmtr <- cutLexis(bmt, cut = bmt$prtime/365.25, precursor.states = "Tx",
                                           new.state = "PR")
summary(bmtr)


## ---- fig.show='hold',fig.cap="Simple figure"----------------------------
DiagrammeR::grViz(boxesLx(bmtr))


## ---- fig.show='hold',,fig.cap="Simple figure with 'dot' engine"---------
 
DiagrammeR::grViz(boxesLx(bmtr,layout="dot"))
 

## ---- fig.show='hold',fig.cap="More colors and shapes in figure"---------

DiagrammeR::grViz(boxesLx(bmtr,node.attr='shape=hexagon color=navy style=filled fillcolor=lightblue',
edge.attr = ' color=steelblue ',layout="circo",prop.penwidth=TRUE))


## ------------------------------------------------------------------------

library(survival)
tmp.lt1<-mkratetable(Surv(time,status)~ sex,data=lung)
tmp.lt2<-mkratetable(Surv(time,status)~ sex,data=lung,add.RR=TRUE,lowest.N=60)

## ----results='asis'------------------------------------------------------

knitr::kable(tmp.lt1, caption="Incidence rates with 95% CI")
knitr::kable(tmp.lt2, caption="Incidence rates and incidence rate ratios with 95% CI. Number of cases under 60 replaced with '999999'")


## ----fig.cap="Hazard with 95% confidence interval", message=FALSE, warning=FALSE----
require(survival)

tmp.hz<-estim.hazard(time=lung$time,status=lung$status)
# Few lines from resultin data.frame 'tmp.hz'
head(tmp.hz,4)
# Estimation parameters
attributes(tmp.hz)$estim.hazard.param 

require(ggplot2)
ggplot(tmp.hz,
       aes(x = time.eval, y = haz)) +
  # Add a ribbon with the confidence band
  geom_smooth(
    aes(
      # lower and upper bound of the ribbon
      ymin = haz.lo, ymax = haz.hi), stat = "identity") +
  xlab("Time (d)") +ylab("Hazard")+ylim(c(0,0.01))+xlim(c(0,2*365))



## ----fig.cap="Hazard with 95% confidence interval. User defined knots for spline.", message=FALSE, warning=FALSE----
# Define knots for spline
tmp.kn<-data.frame(knt=c(100,200,400,600))

tmp.hz1<-estim.hazard(time=lung$time,status=lung$status,knots=tmp.kn$knt)
# Estimation parameters
attributes(tmp.hz1)$estim.hazard.param 

ggplot(tmp.hz1,aes(x = time.eval, y = haz)) +
  geom_smooth(aes(ymin = haz.lo, ymax = haz.hi), stat = "identity") +
  xlab("Time (d)") +ylab("Hazard")+ylim(c(0,0.01))+xlim(c(0,2*365))+
  geom_rug(data=tmp.kn,aes(x = knt,y = NULL),sides="b") 

