% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-arguments.R
\name{checkObject}
\alias{checkObject}
\title{Variable check for single objects.}
\usage{
checkObject(obj, obj.name, ..., out = "return", .env)
}
\arguments{
\item{obj}{[\code{any}]\cr
Variable or value to check and convert.}

\item{obj.name}{[\code{character(1)}]\cr
Name of the object to check.
If \code{missing}, the name of \code{obj} has to be one of the possible
names (see details).}

\item{...}{[\code{any}]\cr
An alternative to the use of the \code{obj} and \code{obj.name} arguments
is to directly give the name and the variable to be checked via
\code{name = variable} arguments (see examples). In the case of more than
one \code{...} argument, \code{\link{checkVars}} will be called internally.}

\item{out}{[\code{character}]\cr
Whether to \code{"return"} or to \code{"assign"} the checked
(and converted) object. Also possible: \code{c("return", "assign")}.}

\item{.env}{[\code{environment}]\cr
Environment to which to assign the converted \code{obj} (usually the
same on that contains \code{obj}, if it's a variable).\cr
Required, if argument \code{out} contains \code{"assign"}.}
}
\value{
The checked and converted argument is assigned to
  the given environment (\code{.env}) and/or returned (depending on the
  argument \code{out}).
}
\description{
Checking the variable and convert it for internal use, if necessary.
(Also used by the \code{cointmonitoR} package.)
}
\details{
Possible values of \code{obj.name} to check:
\describe{
  \item{\code{"y"}, \code{"x.stat"}:}{
  Of type \code{numeric}, \code{matrix} or \code{data.frame}.
  Only the first row/column will be used.\cr
  Converted to object: column matrix}

  \item{\code{"y.fm"}, \code{"x.coint"}, \code{"deter"}:}{
  Of type \code{numeric}, \code{matrix} or \code{data.frame}.\cr
  Converted to object: column matrix}

  \item{\code{"m"}:}{
  Of type \code{numeric(1)}, has to be greater than 0.}

  \item{\code{"model"}:}{
  One of \code{c("FM", "D", "IM")}.}

  \item{\code{"signif.level"}:}{
  Of type \code{numeric(1)}, has to be in the interval [0.01, 0.1].}

  \item{\code{"trend"}, \code{"return.stats"}, \code{"return.input"},
        \code{"demeaning"}, \code{"t.test"}:}{
  Converted to object: \code{logical(1)}.}

  \item{\code{"kernel"}:}{
  One of \code{c("ba", "bo", "da", "pa", "qs", "th", "tr")}.}

  \item{\code{"bandwidth"}:}{
  One of \code{c("and", "nw")}.}

  \item{\code{"selector"}:}{
  One or both \code{c(1, 2)}.}

}
}
\examples{
x = matrix(1:20, nrow = 2)
x2 = checkObject(x, "x.coint")
x2

env = environment()
y = 1:10
checkObject(y, out = "assign", .env = env)
y

# example for the use of the ... argument:
det = rbind(1, 1:10)
x3 = sin(10:20)
det2 = checkObject(deter = det)
det2
(checkObject(deter = det, x.stat = x3))

}
\seealso{
Other check: \code{\link{checkDoptions}},
  \code{\link{checkVars}}
}

