% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deque.R
\name{Deque}
\alias{Deque}
\title{Double Ended Queue}
\usage{
Deque(items = NULL)
}
\arguments{
\item{items}{a list of items}
}
\description{
The \code{Deque} function creates a double ended queue.
}
\details{
Following methods are exposed:
\preformatted{
.$push(item)
.$pushleft(item)
.$pop()
.$popleft()
.$peek()
.$peekleft()
.$extend(q)
.$extendleft(q)
.$remove(item)
.$clear()
.$size()
.$as_list()
.$print()
}
\itemize{
\item \code{item}: any R object
\item \code{q}: a Deque object
}
}
\examples{
q <- Deque()
q$push("foo")
q$push("bar")
q$pushleft("baz")
q$pop()  # bar
q$popleft()  # baz

q <- Deque(list("foo", "bar"))
q$push("baz")$pushleft("bla")
}
\seealso{
\link{DequeL}
}
