% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference_order.R
\name{auc_score}
\alias{auc_score}
\title{Area Under the Receiver Operating Characteristic}
\usage{
auc_score(observed = NULL, predicted = NULL)
}
\arguments{
\item{observed}{(required, integer) Numeric vector with observations. Valid values are 1 and 0. Must have the same length as \code{predicted}. Default: NULL}

\item{predicted}{(required, numeric) Numeric vector in the range 0-1 with binary model predictions. Must have the same length as \code{observed}.}
}
\value{
AUC value.
}
\description{
Computes the AUC score of binary model predictions.
}
\examples{

 out <- auc_score(
   observed = c(0, 0, 1, 1),
   predicted = c(0.1, 0.6, 0.4, 0.8)
   )

}
