% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preference_order.R
\name{f_logistic_auc_balanced}
\alias{f_logistic_auc_balanced}
\title{AUC of Binomial GLM with Logit Link}
\usage{
f_logistic_auc_balanced(x, y, df)
}
\arguments{
\item{x}{(required, character string) name of the predictor variable.}

\item{y}{(required, character string) name of the binary response variable}

\item{df}{(required, data frame) data frame with the columns 'x' and 'y'.}
}
\value{
Area Under the Curve
}
\description{
Fits a logistic GLM model \code{y ~ x} when \code{y} is a binary response with values 0 and 1 and \code{x} is numeric. This function is suitable when the response variable is balanced. If the response is unbalanced, then \code{\link[=f_logistic_auc_unbalanced]{f_logistic_auc_unbalanced()}} should provide better results.
}
\examples{

data(vi)

#subset to limit example run time
vi <- vi[1:1000, ]

f_logistic_auc_balanced(
  x = "growing_season_length", #predictor
  y = "vi_binary",             #binary response
  df = vi
)

}
