% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{toy}
\alias{toy}
\title{One response and four predictors with varying levels of multicollinearity}
\format{
Data frame with 2000 rows and 5 columns.
}
\usage{
data(toy)
}
\description{
Data frame with known relationship between responses and predictors useful
to illustrate multicollinearity concepts. Created from \link{vi} using the code
shown in the example.
}
\details{
Columns:
\itemize{
\item \code{y}: response variable generated from \code{a * 0.75 + b * 0.25 + noise}.
\item \code{a}: most important predictor of \code{y}, uncorrelated with \code{b}.
\item \code{b}: second most important predictor of \code{y}, uncorrelated with \code{a}.
\item \code{c}: generated from \code{a + noise}.
\item \code{d}: generated from \code{(a + b)/2 + noise}.
}

These are variance inflation factors of the predictors in \code{toy}.
variable vif
b       4.062
d       6.804
c       13.263
a       16.161
}
\examples{

library(collinear)
library(dplyr)
data(vi)
set.seed(1)
toy <- vi |>
  dplyr::slice_sample(n = 2000) |>
  dplyr::transmute(
    a = soil_clay,
    b = humidity_range
  ) |>
  scale() |>
  as.data.frame() |>
  dplyr::mutate(
    y = a * 0.75 + b * 0.25 + runif(n = dplyr::n(), min = -0.5, max = 0.5),
    c = a + runif(n = dplyr::n(), min = -0.5, max = 0.5),
    d = (a + b) / 2 + runif(n = dplyr::n(), min = -0.5, max = 0.5)
  ) |>
  dplyr::transmute(y, a, b, c, d)

}
\keyword{datasets}
