% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{roi_check}
\alias{roi_check}
\title{Show pixel intensities}
\usage{
roi_check(img, ind = c(1, 2))
}
\arguments{
\item{img}{A \code{\link[imager]{cimg}} object or a \code{list} of multiple
images such as the one returned from \code{\link{roi_select}}}

\item{ind}{A \code{numeric} object of length two. For the channel indexes.
or a \code{list} of similar vectors for each of \code{img} items.}
}
\description{
Show the pixel intensities of certain image channels
}
\details{
Calling this function returns two plots. The first is a scatter
plot of the pixel intensities from two channels. The second is the density
distribution of the intensities from the two channels.
}
\examples{
# load images
fl <- system.file('extdata', 'Image0001_.jpg', package = 'colocr')
img <- image_load(fl)

# choose ROI and show the pixel intensities
oldpar <- par()
par(mfrow = c(1, 2))

roi_select(img, threshold = 90) \%>\%
  roi_check()

par(oldpar)

}
