% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison_metrics.R
\name{weightedPairsDistance}
\alias{weightedPairsDistance}
\title{Distance between color clusters with user-specified color/size weights}
\usage{
weightedPairsDistance(T1, T2, ordering = FALSE, sizeWeight = 0.5,
  colorWeight = 0.5)
}
\arguments{
\item{T1}{Dataframe (especially a dataframe as returned by
\code{extractClusters} or \code{getImageHist}, but first three columns must
be coordinates).}

\item{T2}{Another dataframe like T1.}

\item{ordering}{Logical. Should clusters by paired in order to minimize
overall distance scores or evaluated in the order given?}

\item{sizeWeight}{Weight of size similarity in determining overall score and
ordering (if ordering=T).}

\item{colorWeight}{Weight of color similarity in determining overall score
and ordering (if ordering=T). Color and size weights do not necessarily
have to sum to 1.}
}
\value{
Similarity score based on size and color similarity of each pair of
  points in provided dataframes.
}
\description{
Distance metric with optional user input for specifying how much the bin size
similarity and color similarity should be weighted when pairing clusters from
different color cluster sets.
}
\note{
Use with caution, since weights can easily swing distance scores more
  dramatically than might be expected. For example, if \code{sizeWeight} = 1
  and \code{colorWeight} = 0, two clusters of identical color but different
  sizes would not be compared.
}
\examples{
clusterList <- colordistance::getKMeansList(system.file("extdata",
"Heliconius/Heliconius_B", package="colordistance"), lower=rep(0.8, 3),
upper=rep(1, 3))
clusterList <- colordistance::extractClusters(clusterList, ordering=TRUE)
colordistance:::weightedPairsDistance(clusterList[[1]], clusterList[[2]],
sizeWeight=0.8, colorWeight=0.2)
}
