% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_comparison_metrics.R
\name{getColorDistanceMatrix}
\alias{getColorDistanceMatrix}
\title{Distance matrix for a list of color cluster sets}
\usage{
getColorDistanceMatrix(cluster.list, method = "emd", ordering = "default",
  size.weight = 0.5, color.weight = 0.5, plotting = TRUE, ...)
}
\arguments{
\item{cluster.list}{A list of identically sized dataframes with 4 columns each
(R, G, B, Pct or H, S, V, Pct) as output by \code{extractClusters} or
\code{getHistList}.}

\item{method}{One of four possible comparison methods for calculating the
color distances: \code{"emd"} (uses \code{\link{EMDistance}}, recommended),
\code{"chisq"} (uses \code{\link{chisqDistance}}), \code{"color.dist"}
(uses \code{\link{colorDistance}}; not appropriate if binAvg=F), or
\code{"weighted.pairs"} (\code{\link{weightedPairsDistance}}).}

\item{ordering}{Logical if not left as "default". Should the color clusters
in the list be reordered to minimize the distances between the pairs? If
left as default, ordering depends on distance method: "emd" and "chisq" do
not order clusters ("emd" orders on a case-by-case in the
\code{\link{EMDistance}} function itself and reordering by size similarity
would make chi-squared meaningless); "color.dist" and "weighted.pairs" use
ordering. To override defaults, set to either \code{T} (for ordering) or
\code{F} (for no ordering).}

\item{size.weight}{Same as in \code{\link{weightedPairsDistance}}.}

\item{color.weight}{Same as in \code{\link{weightedPairsDistance}}.}

\item{plotting}{Logical. Should a heatmap of the distance matrix be displayed
once the function finishes running?}

\item{...}{Additional arguments passed on to
\code{\link{heatmapColorDistance}}.}
}
\value{
A distance matrix of image distance scores (the scales vary depending
  on the distance metric chosen, but for all four methods, higher scores =
  more different).
}
\description{
Calculates a distance matrix for a list of color cluster sets as returned by
\code{\link{extractClusters}} or \code{\link{getHistList}} based on the
specified distance metric.
}
\details{
Each cell represents the distance between a pair of color cluster
sets as measured using either chi-squared distance (cluster size only), earth
mover's distance (size and color), weighted pairs (size and color with
user-specified weights for each), or color distance (Euclidean distance
between clusters as 3-dimensional - RGB or HSV - color coordinates).

Earth mover's distance is recommended unless \code{binAvg} is set to false
during cluster list generation (in which case all paired bins will have the
same colors across datasets), in which case chi-squared is recommended.
Weighted pairs or color distance may be appropriate depending on the
question, but generally give poorer results.
}
\examples{
\dontrun{
cluster.list <- colordistance::getHistList(c(system.file("extdata",
"Heliconius/Heliconius_A", package="colordistance"), system.file("extdata",
"Heliconius/Heliconius_B", package="colordistance")), lower=rep(0.8, 3),
upper=rep(1, 3))

# Default values - recommended!
colordistance::getColorDistanceMatrix(cluster.list, main="EMD")

# Without plotting
colordistance::getColorDistanceMatrix(cluster.list, plotting=FALSE)

# Use chi-squared instead
colordistance::getColorDistanceMatrix(cluster.list, method="chisq", main="Chi-squared")

# Override ordering (throws a warning if you're trying to do this with
# chisq!)
colordistance::getColorDistanceMatrix(cluster.list, method="chisq",
ordering=TRUE, main="Chi-squared w/ ordering")

# Specify high size weight/low color weight for weighted pairs
colordistance::getColorDistanceMatrix(cluster.list, method="weighted.pairs",
color.weight=0.1, size.weight=0.9, main="Weighted pairs")

# Color distance only
colordistance::getColorDistanceMatrix(cluster.list, method="color.dist",
ordering=TRUE, main="Color distance only")
}
}
