

test_that("string color conversion works", {
  
  cols1 <- c(NA_character_, 'transparent')
  expect_identical(
    grDevices::col2rgb(cols1, alpha = TRUE),
    col_to_rgb(cols1)
  )
  
})

test_that("string color conversion works", {
  
  cols1 <- sample(colors(), 1000, T)
  cols2 <- rgb(t(col2rgb(cols1)), maxColorValue = 255)
  
  identical(
    grDevices::col2rgb(cols1, alpha = TRUE),
    col_to_rgb(cols1)
  )
  
  expect_identical(
    grDevices::col2rgb(cols2, alpha = TRUE),
    col_to_rgb(cols2)
  )
  
})



test_that("conversion to native raster works", {
  
  # farver::encode_native(colors())  |> dput()
  farver_ref <- c(
    -1L, -1808L, -2626566L, -2363393L, -3350546L, -5193523L, -8879221L, 
    -2818177L, -2818177L, -3740042L, -5583514L, -9139387L, -16L, 
    -16L, -1118496L, -3289663L, -7631997L, -2296331L, -3873537L, 
    -3873537L, -4729362L, -6375475L, -9732725L, -16777216L, -3281921L, 
    -65536L, -65536L, -1179648L, -3342336L, -7667712L, -1954934L, 
    -14013787L, -12566273L, -12895250L, -13421619L, -14474357L, -7882530L, 
    -6564865L, -7223826L, -8541491L, -11177077L, -6250913L, -2664L, 
    -1120882L, -3291782L, -7633325L, -16711809L, -16711809L, -16716170L, 
    -16724634L, -16741563L, -14784046L, -14385153L, -14584082L, -14850355L, 
    -15514229L, -11501569L, -11111681L, -11506962L, -12231731L, -13681013L, 
    -1206940L, -2295553L, -2295553L, -3282706L, -5125939L, -8877941L, 
    -256L, -256L, -1118720L, -3289856L, -7632128L, -7667712L, -7632128L, 
    -16021832L, -15746561L, -15815186L, -15952435L, -16226933L, -5658199L, 
    -16751616L, -5658199L, -9717827L, -7667573L, -13669547L, -9371702L, 
    -9900356L, -10826334L, -12743826L, -16741121L, -16744449L, -16746770L, 
    -16750899L, -16759413L, -3394919L, -49473L, -1164622L, -3329382L, 
    -7658904L, -16777077L, -8743191L, -7357297L, -4063295L, -4919628L, 
    -6566501L, -9860247L, -7652024L, -11579601L, -105L, -1118579L, 
    -3289735L, -7632046L, -11579601L, -3027456L, -2948972L, -7138049L, 
    -7138049L, -7793938L, -9039667L, -11531637L, -16640L, -16640L, 
    -1134080L, -3302912L, -7641088L, -9868951L, -9868951L, -28642L, 
    -28642L, -1145316L, -3312616L, -7647728L, -14540110L, -13618945L, 
    -13882130L, -14276915L, -15066485L, -984321L, -14513374L, -2302756L, 
    -1800L, -16721921L, -16721921L, -16725522L, -16732723L, -16747125L, 
    -14637606L, -14302721L, -14502674L, -14836787L, -15439477L, -4276546L, 
    -16777216L, -16579837L, -16448251L, -16250872L, -16119286L, -15921907L, 
    -15790321L, -15592942L, -15461356L, -15263977L, -15066598L, -14935012L, 
    -14737633L, -14606047L, -14408668L, -14277082L, -14079703L, -13948117L, 
    -13750738L, -13619152L, -13421773L, -13224394L, -13092808L, -12895429L, 
    -12763843L, -12566464L, -12434878L, -12237499L, -12105913L, -11908534L, 
    -11711155L, -11579569L, -11382190L, -11250604L, -11053225L, -10921639L, 
    -10724260L, -10592674L, -10395295L, -10263709L, -10066330L, -9868951L, 
    -9737365L, -9539986L, -9408400L, -9211021L, -9079435L, -8882056L, 
    -8750470L, -8553091L, -8421505L, -8224126L, -8026747L, -7895161L, 
    -7697782L, -7566196L, -7368817L, -7237231L, -7039852L, -6908266L, 
    -6710887L, -6513508L, -6381922L, -6184543L, -6052957L, -5855578L, 
    -5723992L, -5526613L, -5395027L, -5197648L, -5000269L, -4868683L, 
    -4671304L, -4539718L, -4342339L, -4210753L, -4013374L, -3881788L, 
    -3684409L, -3552823L, -3355444L, -3158065L, -3026479L, -2829100L, 
    -2697514L, -2500135L, -2368549L, -2171170L, -2039584L, -1842205L, 
    -1710619L, -1513240L, -1315861L, -1184275L, -986896L, -855310L, 
    -657931L, -526345L, -328966L, -197380L, -1L, -16711936L, -16711936L, 
    -16716288L, -16724736L, -16741632L, -13631571L, -4276546L, -16777216L, 
    -16579837L, -16448251L, -16250872L, -16119286L, -15921907L, -15790321L, 
    -15592942L, -15461356L, -15263977L, -15066598L, -14935012L, -14737633L, 
    -14606047L, -14408668L, -14277082L, -14079703L, -13948117L, -13750738L, 
    -13619152L, -13421773L, -13224394L, -13092808L, -12895429L, -12763843L, 
    -12566464L, -12434878L, -12237499L, -12105913L, -11908534L, -11711155L, 
    -11579569L, -11382190L, -11250604L, -11053225L, -10921639L, -10724260L, 
    -10592674L, -10395295L, -10263709L, -10066330L, -9868951L, -9737365L, 
    -9539986L, -9408400L, -9211021L, -9079435L, -8882056L, -8750470L, 
    -8553091L, -8421505L, -8224126L, -8026747L, -7895161L, -7697782L, 
    -7566196L, -7368817L, -7237231L, -7039852L, -6908266L, -6710887L, 
    -6513508L, -6381922L, -6184543L, -6052957L, -5855578L, -5723992L, 
    -5526613L, -5395027L, -5197648L, -5000269L, -4868683L, -4671304L, 
    -4539718L, -4342339L, -4210753L, -4013374L, -3881788L, -3684409L, 
    -3552823L, -3355444L, -3158065L, -3026479L, -2829100L, -2697514L, 
    -2500135L, -2368549L, -2171170L, -2039584L, -1842205L, -1710619L, 
    -1513240L, -1315861L, -1184275L, -986896L, -855310L, -657931L, 
    -526345L, -328966L, -197380L, -1L, -983056L, -983056L, -2036000L, 
    -4076095L, -8156285L, -4953601L, -4952321L, -5805330L, -7315251L, 
    -10339701L, -10724147L, -9803009L, -10263570L, -11184691L, -12961141L, 
    -983041L, -983041L, -2035986L, -4076083L, -8156277L, -7543056L, 
    -7342337L, -8001810L, -9189683L, -11630965L, -334106L, -659201L, 
    -659201L, -1711890L, -3817011L, -7961717L, -16712580L, -3278081L, 
    -3278081L, -4199954L, -5912115L, -9401973L, -1648467L, -4161L, 
    -1122382L, -3293030L, -7634072L, -8355600L, -32L, -32L, -1118511L, 
    -3289676L, -7632006L, -8200722L, -7607041L, -8200978L, -9388339L, 
    -11763317L, -2950406L, -2894893L, -7278960L, -2894893L, -4081921L, 
    -4608257L, -5397778L, -6976307L, -10133621L, -8740609L, -8740609L, 
    -9267730L, -10321459L, -12429429L, -5590496L, -340345L, -7504L, 
    -1125468L, -3295603L, -7636128L, -36732L, -6715273L, -6715273L, 
    -2177872L, -7734L, -1125700L, -3295838L, -7636114L, -2031617L, 
    -2031617L, -3019026L, -4928051L, -8746101L, -13447886L, -1642246L, 
    -65281L, -65281L, -1179410L, -3342131L, -7667573L, -10473296L, 
    -5032705L, -5820178L, -7329331L, -10347381L, -5583514L, -3342336L, 
    -2927174L, -39200L, -1155119L, -3321164L, -7653510L, -2396013L, 
    -32085L, -1148513L, -3315575L, -7649443L, -9325764L, -1152901L, 
    -6620672L, -3354296L, -8055353L, -9430759L, -327691L, -1972993L, 
    -1972993L, -2959890L, -4868147L, -8684149L, -4856577L, -5382401L, 
    -5382401L, -6172690L, -7621683L, -10585717L, -8388608L, -8388608L, 
    -1640963L, -14446997L, -12648512L, -12915021L, -13447782L, -14513303L, 
    -16734721L, -16734721L, -16737554L, -16742963L, -16754037L, -16759297L, 
    -16759297L, -16760594L, -16762931L, -16767605L, -2723622L, -359425L, 
    -1475858L, -3577395L, -7780469L, -5576466L, -6751336L, -6619238L, 
    -7278960L, -8598148L, -11236524L, -1118545L, -69L, -1118546L, 
    -3289706L, -7632026L, -7114533L, -5537025L, -6325778L, -7771955L, 
    -10664053L, -2756609L, -4596993L, -4596993L, -5387282L, -6967347L, 
    -10127477L, -12614195L, -3424001L, -3820033L, -4675090L, -6385203L, 
    -9673845L, -2252579L, -17409L, -1134866L, -3303731L, -7641461L, 
    -1646416L, -1040224L, -53093L, -1168239L, -3332483L, -7660971L, 
    -16776961L, -16776961L, -16776978L, -16777011L, -16777077L, -7368772L, 
    -4079105L, -4934418L, -6579251L, -9868917L, -2004671L, -35256L, 
    -1151421L, -3317958L, -7651289L, -15514229L, -9273094L, -9859841L, 
    -10321170L, -11243315L, -13022069L, -10443532L, -11039954L, -6291628L, 
    -7016882L, -8336061L, -11039954L, -1116673L, -1116673L, -2169362L, 
    -4209203L, -8223093L, -13806944L, -12090625L, -12420626L, -13014835L, 
    -14268533L, -1323385L, -12665L, -1130370L, -3299732L, -7638966L, 
    -3319190L, -36989L, -1153158L, -3319447L, -7652281L, -7307152L, 
    -7482L, -1125447L, -3295585L, -7636116L, -7307152L, -328961L, 
    -328961L, -1447442L, -3552819L, -7763573L, -8388864L, -8388864L, 
    -8983040L, -10040064L, -12219648L, -4947386L, -18333L, -1135524L, 
    -3304369L, -7642058L, -7555886L, -11557377L, -11953426L, -12614195L, 
    -13935989L, -2572328L, -7681L, -1125650L, -3295795L, -7636085L, 
    -12098561L, -12098561L, -12428050L, -13021235L, -14272885L, -3088320L, 
    -2816L, -1121024L, -3291904L, -7633408L, -1146130L, -7331632L, 
    -6930689L, -7587090L, -8899891L, -11394421L, -4989195L, -4528129L, 
    -5318418L, -6898995L, -10060149L, -657931L, -16711681L, -16711681L, 
    -16716050L, -16724531L, -16741493L, -13447782L)
  
  
  expect_identical(
    col_to_int(colors()),
    farver_ref
  )

})





