% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\name{map_single}
\alias{map_single}
\title{Visualize distributions in a single map}
\usage{
map_single(
  x,
  palette,
  layer,
  lambda_i = 0,
  lambda_s = 0,
  return_type = c("plot", "stack", "df")
)
}
\arguments{
\item{x}{RasterStack of distributions processed by \code{\link[=metrics_pull]{metrics_pull()}} or
\code{\link[=metrics_distill]{metrics_distill()}}.}

\item{palette}{data frame containing an HCL color palette generated using
\code{\link[=palette_timecycle]{palette_timecycle()}}, \code{\link[=palette_timeline]{palette_timeline()}}, or \code{\link[=palette_set]{palette_set()}}.}

\item{layer}{integer (or character) corresponding to the layer ID (or name)
of layer. A single distribution from within \code{x} is mapped when the \code{layer}
argument is specified. The \code{layer} argument is ignored if
\code{\link[=metrics_distill]{metrics_distill()}} was used to generate \code{x}.}

\item{lambda_i}{number that allows visual tuning of intensity values via the
\code{\link[scales:boxcox_trans]{scales::modulus_trans()}} function (see Details). Negative numbers increase
the opacity of cells with low intensity values. Positive numbers decrease
the opacity of cells with low intensity values.}

\item{lambda_s}{number that allows visual tuning of specificity values via
the \code{\link[scales:boxcox_trans]{scales::modulus_trans()}} function (see Details). Negative numbers
increase the chroma of cells with low specificity values. Positive numbers
decrease the chroma of cells with low specificity values.}

\item{return_type}{character specifying whether the function should return a
\code{ggplot2} plot object ("plot"), \code{RasterStack} ("stack"), or data frame
("df"). The default is to return a \code{ggplot2} object.}
}
\value{
By default, or when \code{return_type = "plot"}, the function returns a
map that is a \code{ggplot2} plot object.

When \code{return_type = "stack"}, the function returns a \code{RasterStack}
containing five layers that enable RGBa visualization of a map using other
R packages or external GIS software:
\itemize{
\item \code{R}: red, integer values (0-255).
\item \code{G}: green, integer values (0-255).
\item \code{B}: blue, integer values (0-255).
\item \code{alpha}: opacity, numeric values (0-255).
\item \code{n_layers}: number of layers in \code{x} with non-NA values.
}

When \code{return_type = "df"}, the function returns a data frame containing
seven columns:
\itemize{
\item \code{x},\code{y}: coordinates of raster cell centers.
\item \code{cell_number}: integer indicating the cell number within the raster.
\item \code{intensity}: maximum cell value across layers divided by the maximum
value across all layers and cells; mapped to alpha level.
\item \code{specificity}: the degree to which intensity values are unevenly
distributed across layers; mapped to chroma.
\item \code{layer_id}: integer identifying the layer containing the maximum
intensity value; mapped to hue.
\item \code{color}: the hexadecimal color associated with the given layer and
specificity values.
}
}
\description{
This function enables visualization of distributional
information in a single map by combining distribution metrics and an HCL
color palette.
}
\details{
The \code{lambda_i} parameter allows for visual tuning of intensity
values with unusual distributions. For example, distributions often
contain highly skewed intensity values because individuals spend a vast
majority of their time within a relatively small area or because
populations are relatively dense during some seasons and relatively
dispersed during others. This can make visualizing distributions a
challenge. The \code{lambda_i} parameter transforms intensity values via the
\code{\link[scales:boxcox_trans]{scales::modulus_trans()}} function, allowing users to adjust the relative
visual weight of high and low intensity values.

The \code{lambda_s} parameter allows for visual tuning of specificity
values via the \code{\link[scales:boxcox_trans]{scales::modulus_trans()}} function. Adjustment of
\code{lambda_s} affects the distribution of chroma values across areas of
relatively low and high specificity, thus modifying information available
to viewers. USE WITH CAUTION!
}
\examples{
# load elephant data
data("elephant_ud")

# prepare metrics
r <- metrics_distill(elephant_ud)

# generate palette
pal <- palette_set(elephant_ud)

# produce map, adjusting lambda_i to make areas that were used less
# intensively more conspicuous
map_single(r, pal, lambda_i = -5)

# return RasterStack containing RGBa values
m <- map_single(r, pal, lambda_i = -5, return_type = "stack")

# visualize RGBa values
library(raster)
plotRGB(m, 1, 2, 3, alpha = as.vector(m[[4]]))
}
\seealso{
Other map: 
\code{\link{map_multiples}()}
}
\concept{map}
