% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/divergingx_hcl.R
\name{divergingx_hcl}
\alias{divergingx_hcl}
\alias{divergex_hcl}
\alias{divergingx_palettes}
\title{(More) Flexible Diverging HCL Palettes}
\usage{
divergingx_hcl(n, palette = "Geyser", ..., rev = FALSE, h1, h2, h3, c1,
  c2, c3, l1, l2, l3, p1, p2, p3, p4, cmax1, cmax2)

divergingx_palettes(palette = NULL, plot = FALSE, n = 7L, ...)
}
\arguments{
\item{n}{the number of colors (\eqn{\ge 1}{>= 1}) to be in the palette.}

\item{palette}{character with the name (see details).}

\item{\dots}{arguments passed to \code{\link{sequential_hcl}}.}

\item{rev}{logical. Should the palette be reversed?}

\item{h1}{numeric. Starting hue coordinate.}

\item{h2}{numeric. Center hue coordinate.}

\item{h3}{numeric. Ending hue coordinate.}

\item{c1}{numeric. Chroma coordinate corresponding to \code{h1}.}

\item{c2}{numeric. Chroma coordinate corresponding to \code{h2} (if \code{NA}, set to 0).}

\item{c3}{numeric. Chroma coordinate corresponding to \code{h3}.}

\item{l1}{numeric. Luminance coordinate corresponding to \code{h1}.}

\item{l2}{numeric. Luminance coordinate corresponding to \code{h2}.}

\item{l3}{numeric. Luminance coordinate corresponding to \code{h3} (if \code{NA}, \code{l1} is used).}

\item{p1}{numeric. Power parameter for chroma coordinates in first sequential palette.}

\item{p2}{numeric. Power parameter for luminance coordinates in first sequential palette (if \code{NA}, \code{p1} is used).}

\item{p3}{numeric. Power parameter for chroma coordinates in second sequential palette (if \code{NA}, \code{p1} is used).}

\item{p4}{numeric. Power parameter for luminance coordinates in second sequential palette (if \code{NA}, \code{p3} is used).}

\item{cmax1}{numeric. Maximum chroma coordinate in first sequential palette (not used if \code{NA}).}

\item{cmax2}{numeric. Maximum chroma coordinate in second sequential palette (if \code{NA}, \code{cmax1} is used).}

\item{plot}{logical. Should the selected HCL color palettes be visualized?}
}
\value{
A character vector with (s)RGB codings of the colors in the palette.
}
\description{
Diverging HCL color palettes generated through combination of two fully
flexible (and possibly unbalanced) multi-hue sequential palettes.
}
\details{
The \code{divergingx_hcl} function simply calls \code{\link{sequential_hcl}}
twice with a prespecified set of hue, chroma, and luminance parameters. This is
similar to \code{\link{diverging_hcl}} but allows for more flexibility:
\code{diverging_hcl} employs two \emph{single-hue} sequential palettes,
always uses zero chroma for the neutral/central color, and restricts the
chroma/luminance path to be the same in both \dQuote{arms} of the palette.
In contrast, \code{divergingx_hcl} relaxes this to two full \emph{multi-hue}
palettes that can thus go through a non-gray neutral color (typically light
yellow). Consequently, the chroma/luminance paths can be rather unbalanced
between the two arms.

With this additional flexibility various diverging palettes suggested by
\url{http://ColorBrewer.org/} and CARTO (\url{https://carto.com/carto-colors/})
can be emulated.

Available CARTO palettes: ArmyRose, Earth, Fall, Geyser, TealRose, Temps, and
Tropic (with Tropic also available in \code{diverging_hcl}).

Available ColorBrewer.org palettes: PuOr, RdBu, RdGy, PiYG, PRGn, BrBG, RdYlBu,
RdYlGn, Spectral.
}
\examples{
## show emulated CARTO/ColorBrewer.org palettes
divergingx_palettes(plot = TRUE)

## compared to diverging_hcl() the diverging CARTO palettes are typically warmer
## but also less balanced with respect to chroma/luminance, see e.g.,
specplot(divergingx_hcl(7, "ArmyRose"))
}
\seealso{
\code{\link[colorspace]{sequential_hcl}}, \code{\link[colorspace]{diverging_hcl}}
}
\keyword{color}
