% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specplot.R
\name{specplot}
\alias{specplot}
\title{Color Spectrum Plot}
\usage{
specplot(
  x,
  y = NULL,
  rgb = FALSE,
  hcl = TRUE,
  fix = TRUE,
  cex = 1,
  type = "l",
  lwd = 2 * cex,
  lty = 1,
  pch = NULL,
  mar = NULL,
  oma = NULL,
  main = NULL,
  legend = TRUE,
  palette = TRUE,
  plot = TRUE,
  ...
)
}
\arguments{
\item{x}{character vector containing color hex codes.}

\item{y}{optional second character vector containing further color hex codes,
to be used for comparing two palettes (\code{x} vs. \code{y}).}

\item{rgb}{logical or color specification. Should the RGB spectrum be
visualized? Can also be a vector of three colors for the legend of R/G/B coordinates.}

\item{hcl}{logical or color specification. Should the HCL spectrum be
visualized? Can also be a vector of three colors for the legend of H/C/L coordinates.}

\item{fix}{logical. Should the hues be fixed to be on a smooth(er) curve?
For details see below.}

\item{cex}{numeric. Character extension for figure axes and labels.}

\item{type, lwd, lty, pch}{plotting parameters passed to
\code{\link[graphics]{lines}} for drawing the RGB and HCL coordinates,
respectively. Can be vectors of length 3.}

\item{mar, oma}{numeric or logical. Either numeric vectors of length 4 giving
the (outer) margins or a logical indicating whether \code{mar}/\code{oma}
should be set.}

\item{main}{character. Main title of the plot.}

\item{legend}{logical. Should legends for the coordinates be plotted?}

\item{palette}{logical. Should the given palette \code{x} be plotted?}

\item{plot}{logical. Should the RGB and/or HCL coordinates be plotted?}

\item{\dots}{currently not used.}
}
\value{
\code{specplot} invisibly returns a list with components
\item{HCL}{a matrix of HCL coordinates,}
\item{RGB}{a matrix of sRGB coordinates,}
\item{hex}{original color palette \code{x}.}
}
\description{
Visualization of color palettes (given as hex codes) in HCL and/or RGB
coordinates.
}
\details{
The function \code{specplot} transforms a given color palette in hex codes
into their HCL (\code{\link[colorspace]{polarLUV}}) and/or RGB
(\code{\link[colorspace]{sRGB}}) coordinates. As the hues for low-chroma
colors are not (or poorly) identified, by default a smoothing is applied to
the hues (\code{fix = TRUE}). Also, to avoid jumps from 0 to 360 or vice
versa, the hue coordinates are shifted suitably.

By default (\code{plot = TRUE}), the resulting HCL and optionally RGB coordinates are
visualized by simple line plots along with the color palette \code{x}
itself. The x-axis simply gives the ordering of the colors in the palette
The y-axis depicts the following information: (1) Hue is drawn in red and
coordinates are indicated on the axis on the right with range [0, 360] or
(if necessary) [-360, 360]. (2) Chroma is drawn in green with coordinates on
the left axis. The range [0, 100] is used unless the palette necessitates
higher chroma values. (3) Luminance is drawn in blue with coordinates on the
left axis in the range [0, 100]. Luminance (and hence also chroma) is on
the left axis because it is arguably most important for understanding the
type of palette (qualitative vs. sequential vs. diverging). To facilitate
reading the legend the reversed order Luminance / Chroma / Hue is used so that
the legend labels are closer to the axis they pertain to.

For comparing two palettes, \code{specplot(x, y)} can be used which adds
lines (dashed, by default) corresponding to the \code{y} palette HCL/RGB
coordinates in the display.
}
\examples{
## spectrum of the (in)famous RGB rainbow palette (in both RGB and HCL)
specplot(rainbow(100), rgb = TRUE)

## spectrum of HCL-based palettes: qualitative/sequential/diverging
specplot(qualitative_hcl(100, "Set 2"))
specplot(sequential_hcl(100, "Blues 2"))
specplot(diverging_hcl(100, "Blue-Red"))

## return computed RGB and HCL coordinates
res <- specplot(rainbow(10), plot = FALSE)
print(res)
}
\references{
Zeileis A, Hornik K, Murrell P (2009).  Escaping RGBland:
Selecting Colors for Statistical Graphics.  \emph{Computational Statistics &
Data Analysis}, \bold{53}, 3259--3270.
\doi{10.1016/j.csda.2008.11.033}
Preprint available from
\url{https://eeecon.uibk.ac.at/~zeileis/papers/Zeileis+Hornik+Murrell-2009.pdf}.

Stauffer R, Mayr GJ, Dabernig M, Zeileis A (2015).  Somewhere over the
Rainbow: How to Make Effective Use of Colors in Meteorological
Visualizations.  \emph{Bulletin of the American Meteorological Society},
\bold{96}(2), 203--216.
\doi{10.1175/BAMS-D-13-00155.1}

Zeileis A, Fisher JC, Hornik K, Ihaka R, McWhite CD, Murrell P, Stauffer R, Wilke CO (2020).
\dQuote{ccolorspace: A Toolbox for Manipulating and Assessing Colors and Palettes.}
\emph{Journal of Statistical Software}, \bold{96}(1), 1--49. \doi{10.18637/jss.v096.i01}
}
\seealso{
\code{\link{hcl_palettes}}, \code{\link{hclplot}}
}
\author{
Reto Stauffer, Achim Zeileis
}
\keyword{hplot}
