# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Coordinates from a matrix
#'
#' This function gets coordinates (row and column numbers) of the matrix cells.
#'
#' @param x A matrix
#' @param cell A vector of cell number.
#' If NULL, the coordinates will be calculated for the whole matrix
#' @keywords internal
rcpp_xy_from_matrix <- function(x, cell = NULL) {
    .Call(`_comat_rcpp_xy_from_matrix`, x, cell)
}

#' Get cell number
#'
#' Get cell number(s) of a matrix from row and column numbers.
#' Cell numbers start at 0 in the upper left corner,
#' and increase from top to bottom, and then from left to right.
#'
#' @param x A matrix
#' @param y A matrix with two columns (row and column numbers)
#' @keywords internal
rcpp_cell_from_xy <- function(x, y) {
    .Call(`_comat_rcpp_cell_from_xy`, x, y)
}

#' Create neighborhood coordinates
#'
#' This function creates a neighborhood coordinates matrix based on the directions parameter.
#'
#' @param directions The number of directions in which cells should be connected:
#' 4 (rook's case), 8 (queen's case), or a neighbourhood matrix.
#' The neighbourhood matrix should have one cell with value 0 (the focal cell),
#' and at least one cell with value 1 (the adjacent cells).
#' Cells with other values (e.g. NA) are ignored.
#' @keywords internal
create_neighborhood <- function(directions) {
    .Call(`_comat_create_neighborhood`, directions)
}

rcpp_get_entropy <- function(x, base = "log2") {
    .Call(`_comat_rcpp_get_entropy`, x, base)
}

get_unique_values <- function(x, na_omit) {
    .Call(`_comat_get_unique_values`, x, na_omit)
}

rcpp_get_cocoma <- function(x, y, directions) {
    .Call(`_comat_rcpp_get_cocoma`, x, y, directions)
}

rcpp_get_coma <- function(x, directions) {
    .Call(`_comat_rcpp_get_coma`, x, directions)
}

rcpp_get_cove <- function(x, ordered) {
    .Call(`_comat_rcpp_get_cove`, x, ordered)
}

#' Wecoma
#'
#' @param x A matrix.
#' @param w A matrix.
#' @param directions A matrix.
#' @param fun "mean", "geometric_mean", or "focal".
#' @param na_action "replace", "omit", "keep"
rcpp_get_wecoma <- function(x, w, directions, fun, na_action) {
    .Call(`_comat_rcpp_get_wecoma`, x, w, directions, fun, na_action)
}

rcpp_get_wecove <- function(x, ordered) {
    .Call(`_comat_rcpp_get_wecove`, x, ordered)
}

triangular_index <- function(r, c) {
    .Call(`_comat_triangular_index`, r, c)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('_comat_RcppExport_registerCCallable', PACKAGE = 'comat')
})
