% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_wecoma.R
\name{get_wecoma}
\alias{get_wecoma}
\title{Create a weighted co-occurrence matrix (wecoma)}
\usage{
get_wecoma(
  x,
  w,
  neighbourhood = 4,
  classes = NULL,
  fun = "mean",
  na_action = "replace"
)
}
\arguments{
\item{x}{A matrix with categories}

\item{w}{A matrix with weights}

\item{neighbourhood}{The number of directions in which cell adjacencies are considered as neighbours:
4 (rook's case) or 8 (queen's case). The default is 4.}

\item{classes}{A vector or a list with the values of selected classes from the \code{x} object.
It is used to calculate wecoma only for selected classes.}

\item{fun}{Function to calculate values from adjacent cells to contribute to output matrix, \code{"mean"} - calculate average values from adjacent cells of weight matrix, \code{"geometric_mean"} - calculate geometric mean values from adjacent cells of weight matrix, or \code{"focal"} assign value from the focal cell.}

\item{na_action}{Decides on how to behave in the presence of missing values in \code{w}. Possible options are \code{"replace"}, \code{"omit"}, \code{"keep"}. The default, \code{"replace"}, replaces missing values with 0, \code{"omit"} does not use cells with missing values, and \code{"keep"} keeps missing values.}
}
\value{
A weighted co-occurrence matrix
}
\description{
Create a weighted co-occurrence matrix (wecoma)
}
\examples{
library(comat)
data(raster_x, package = "comat")
data(raster_w, package = "comat")

wom = get_wecoma(raster_x, raster_w)
wom

get_wecoma(raster_x, raster_w, classes = list(c(1, 3)))
}
