% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcATHBpts.R
\name{calcATHBpts}
\alias{calcATHBpts}
\title{Predicted Thermal Sensation by Gagge using Adaptive Thermal Heat Balance approach}
\usage{
calcATHBpts(trm, psych, ta, tr, vel, rh, met, wme = 0, pb = 760, 
                      ltime = 60, ht = 171, wt = 69.9)
}
\arguments{
\item{trm}{- Running mean outdoor temperature in [degree C]}

\item{psych}{- factor related to fixed effect on perceived control}

\item{ta}{- a numeric value presenting air temperature in [degree C]}

\item{tr}{- a numeric value presenting mean radiant temperature in [degree C]}

\item{vel}{- a numeric value presenting air velocity in [m/s]}

\item{rh}{- a numeric value presenting relative humidity [\%]}

\item{met}{- a numeric value presenting metabolic rate in [met]}

\item{wme}{- a numeric value presenting external work in [met]}

\item{pb}{- a numeric value presenting barometric pressure in [torr] or [mmHg]}

\item{ltime}{- a numeric value presenting exposure time in [minutes]}

\item{ht}{- a numeric value presenting body height in [cm]}

\item{wt}{- a numeric value presenting body weight in [kg]}
}
\value{
\code{calcATHBpts} returns the predicted thermal sensation adapted through the ATHB approach
}
\description{
\code{calcATHB} calculates predicted thermal sensation based on the adaptive thermal heat balance approach 
using Gagge's 2 Node Model
}
\details{
All variables must have the same length 1. For the calculation of several values use function \code{calcComfInd}.
}
\examples{
calcATHBpts(20, 0, 25, 25, .1, 50, 1.1, 0, 760, 60, 171, 70)
}
\references{
Schweiker & Wagner (2015) <doi:10.1016/j.buildenv.2015.08.018>
Schweiker & Wagner (2016) Exploring potentials and limitations of the adaptive thermal heat balance framework Proceedings of 9th Windsor Conference: making comfort relevant Cumberland Lodge, Windsor, UK, 2016
}
\seealso{
see also \code{\link{calcComfInd}}, \code{link{calcATHBpmv}}, \code{link{calcATHBset}}
}
\author{
Marcel Schweiker
}
