\name{compareFile}
\alias{compareFile}
\alias{compareFiles}
\title{ Compare Several Objects }
\description{
  Generate objects by running code from one or more files
  then compare the resulting objects to a set of model
  objects, allowing for and reporting on minor differences.
}
\usage{
compareFile(filename, modelNames,
            modelCode = NULL, modelSave = NULL, modelAnswers = NULL,
            round = FALSE, ...)

compareFiles(filenames, modelNames,
             modelCode=NULL, modelSave=NULL,
             resultNames=filenames, ...) 
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{filename}{ The name of a file containing R code. }
  \item{filenames}{ A vector of names of files containing R code. }
  \item{modelNames}{ A vector of names of objects of interest that
    should be generated by the code in the file(s). }
  \item{modelCode}{ The name of a file that contains R code to generate
    model objects. }
  \item{modelSave}{ The name of a binary file that can be used to load
    model objects. }
  \item{modelAnswers}{ A list containing model objects. }
  \item{round}{ A logical indicating whether to round,
    or an integer indicating how many digits to round to, or a function
    of one argument (that performs something like rounding), or
    a named list of any of those. }
  \item{resultNames}{ A vector of names to be used to identify the
    results from different files. }
  \item{\dots}{ For \code{compareFile()}, arguments to the
    \code{compare()} function; for \code{compareFiles()}, arguments to
    the \code{compareFile()} function. }
}
\details{
  The \code{compareFile()} function is useful for comparing several
  pairs of objects at once, where the comparison objects are generated
  by running R code from a file and the model objects can be generated
  in a number of ways.

  The \code{compareFiles()} function extends this to comparing the same
  set of model objects to several different sets of comparison objects
  (where each set of comparison objects is generated from a separate
  file of R code).
  
  For generating model objects, if a binary file is specified, that is
  used in preference to source code;  if a list of objects is provided,
  that is used;  and if no model objects are specified, they are
  taken from the global workspace (using \code{modelNames}).

  The round argument may be a named list so that different rounding
  is applied to different comparisons.
}
\value{
  \code{compareFile()} returns an object of class
  \code{"comparisonList"}, which is just a list of \code{"comparison"}
  objects.

  \code{compareFiles()} returns an object of class
  \code{"comparisonListList"}.  This is just a list of
  \code{"comparisonList"} objects, but a print method is defined to make
  the display of this object a little more sane.
}
\author{ Paul Murrell }
\seealso{
  \code{\link{compare}}
}
\examples{
modelNames <- c("id", "age", 
                "edu", "class", 
                "IndianMothers")
compareFile(system.file("example", "student1.R", package="compare"),
            modelNames,
            system.file("example", "model.R", package="compare"))
}
\keyword{utilities}
\keyword{logic}
