% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMCresult.R
\name{MCMCresult}
\alias{MCMCresult}
\title{R6 class to hold MCMC samples, timing results, and metrics}
\description{
R6 class to hold MCMC samples, timing results, and metrics

R6 class to hold MCMC samples, timing results, and metrics
}
\seealso{
\code{\link{renameMCMC}} to change the name of an MCMC
method throughout the structure of a list of \code{MCMCresult}
objects.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{MCMC}}{Optional name for the MCMC method.}

\item{\code{samples}}{Matrix of MCMC samples. Rows are for MCMC
iterations.  Columns are for parameters.  Columns must be
named.}

\item{\code{times}}{A list of times including elements for \code{setup},
\code{burnin},  \code{postburnin} (sampling for recorded samples), and
\code{sampling} (normally  \code{burnin} + \code{postburnin}).  Each list
element should be a single numeric value.}

\item{\code{metrics}}{A list of MCMC performance metrics such as
effective sample size (ESS), efficiency, mean, median, and
credible interval boundaries. \code{metrics} ' is organized as a list
with three elements: \code{byMCMC}, \code{byParameter}, and \code{other} '
(currently unused).

\code{byMCMC} is for metrics with one number for an entire
MCMC sample (as opposed to one number for each parameter).
\code{byMCMC} is a data frame with one row and columns for MCMC name
each metric.  These would be metrics where there is a single

\code{byParameter} is for metrics with one number for each parameter in each
MCMC sample.  \code{byParameter} is a \code{data.frame} with one row for each
MCMC-x-parameter combination and columns for MCMC method,
parameter name, and
each metric.  There will only be one MCMC method name
(all entries in the
MCMC column will be the same).

The MCMC columns in \code{byMCMC} and \code{byParameter}
are useful for combining
\code{metrics} from a list of \code{MCMCresult} objects,
such as done by \code{\link{combineMetrics}}, and for retaining
MCMC method labels if these \code{data.frames} are copied and used
outside of
an \code{MCMCresult} object.

\code{other} is simply an arbitrary list. This allows arbitrarily structured
metrics to be saved.

Elements of \code{metrics} are normally populated by \code{addMetrics} or
\code{compareMCMCs}
(which calls \code{addMetrics}).}

\item{\code{sessionInfo}}{Result of running \code{sessionInfo()} prior to calling
an MCMC engine, if requested.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-MCMCresult-new}{\code{MCMCresult$new()}}
\item \href{#method-MCMCresult-setSamples}{\code{MCMCresult$setSamples()}}
\item \href{#method-MCMCresult-rename}{\code{MCMCresult$rename()}}
\item \href{#method-MCMCresult-initializeMetrics}{\code{MCMCresult$initializeMetrics()}}
\item \href{#method-MCMCresult-clearMetrics}{\code{MCMCresult$clearMetrics()}}
\item \href{#method-MCMCresult-addMetricResult}{\code{MCMCresult$addMetricResult()}}
\item \href{#method-MCMCresult-clone}{\code{MCMCresult$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MCMCresult-new"></a>}}
\if{latex}{\out{\hypertarget{method-MCMCresult-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{MCMCresult} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MCMCresult$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Arbitrary initialization.  If a matrix is passed, it
will be used to initialize \code{samples} and the \code{metrics} elements.
If a list with a matrix element named \code{samples} is passed, this element
will be used as if the matrix itself was passed.  Any other named
elements of a list that correspond to fields of an \code{MCMCresult} object
will be initialized from them.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MCMCresult-setSamples"></a>}}
\if{latex}{\out{\hypertarget{method-MCMCresult-setSamples}{}}}
\subsection{Method \code{setSamples()}}{
Populate the samples and initialize the metrics
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MCMCresult$setSamples(samples)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{samples}}{A \code{data.frame} with MCMC output.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MCMCresult-rename"></a>}}
\if{latex}{\out{\hypertarget{method-MCMCresult-rename}{}}}
\subsection{Method \code{rename()}}{
Change the MCMC method name from oldName to newName
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MCMCresult$rename(newName, oldName)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newName}}{New name for MCMC method in \code{metrics}}

\item{\code{oldName}}{Old name for MCMC method in \code{metrics}}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This change the \code{MCMC} field and the corresponding columns
of \code{metrics$byParameter} and \code{metrics$byMCMC}.

If \code{oldName} is not the MCMC method name, this function does nothing.
}

\subsection{Returns}{
NULL
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MCMCresult-initializeMetrics"></a>}}
\if{latex}{\out{\hypertarget{method-MCMCresult-initializeMetrics}{}}}
\subsection{Method \code{initializeMetrics()}}{
Initialize metrics if necessary
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MCMCresult$initializeMetrics(silent = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{silent}}{\code{logical} indicating whether to emit warnings}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
This function does nothing if metrics are already initialized.
It does not clear metrics.  See \code{clearMetrics} for information on
how metrics are initialized.
}

\subsection{Returns}{
\code{logical} indicating whether \code{metrics} is well-formed or not.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MCMCresult-clearMetrics"></a>}}
\if{latex}{\out{\hypertarget{method-MCMCresult-clearMetrics}{}}}
\subsection{Method \code{clearMetrics()}}{
Clear (reset) \code{byParameter} and/or \code{byMCMC} metrics
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MCMCresult$clearMetrics(byParameter = TRUE, byMCMC = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{byParameter}}{\code{logical} indicating whether to clear \code{byParameter}
metrics}

\item{\code{byMCMC}}{\code{logical} indicating whether to clear \code{byMCMC} metrics}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
\code{byParameter} metrics are initialized to a \code{data.frame} with columns for
\code{MCMC} (all the same entry, the \code{MCMC} field) and \code{Parameter}
(taken from column
names of the \code{samples}).

\code{byMCMC} metrics are initialized to a \code{data.frame}
with a column for \code{MCMC}.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MCMCresult-addMetricResult"></a>}}
\if{latex}{\out{\hypertarget{method-MCMCresult-addMetricResult}{}}}
\subsection{Method \code{addMetricResult()}}{
Add one set of metric results
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MCMCresult$addMetricResult(metricResult)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{metricResult}}{A list with possible elements \code{byParameter},
\code{byMCMC}, and
\code{other}.  These are typically returned from a metric function
called via
\code{addMetric}. Each is combined with previous metrics already in the
corresponding
elements of \code{metrics}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-MCMCresult-clone"></a>}}
\if{latex}{\out{\hypertarget{method-MCMCresult-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{MCMCresult$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
