% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/month_tools.R
\name{cs_extract_month}
\alias{cs_extract_month}
\title{Extract Month from Year List Object}
\usage{
cs_extract_month(.data, month)
}
\arguments{
\item{.data}{A list containing monthly crime data}

\item{month}{A string name or abbreviation of a month, or its numeric value.
Acceptable inputs include, for example, "January", "january", "Jan",
"jan", and 1.}
}
\value{
A tibble containing a single month worth of crime data.
}
\description{
This function extracts a given month from a list containing 12
   tibbles - one per month - for additional data cleaning prior to collapsing
   the list. Since months are ordered alphabetically in the year list objects,
   this function makes the process of extracting a particular month more
   intuitive.
}
\examples{
# load example year-list object
load(system.file("testdata", "yearList17.rda", package = "compstatr", mustWork = TRUE))

# extract May
may17 <- cs_extract_month(yearList17, month = 5)
may17 <- cs_extract_month(yearList17, month = "May")

}
\seealso{
\code{\link{cs_replace_month}}
}
