% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ct_country_lookup.R
\name{ct_country_lookup}
\alias{ct_country_lookup}
\title{UN Comtrade country database query}
\usage{
ct_country_lookup(
  search_terms,
  type = c("reporter", "partner"),
  ignore.case = TRUE,
  ...
)
}
\arguments{
\item{search_terms}{Char vector of country names.}

\item{type}{str, the country list to use for the search, valid inputs are
"reporter" and "partner".}

\item{ignore.case}{logical, to be passed along to arg ignore.case within
\code{\link{grepl}}. Default value is TRUE.}

\item{...}{additional args to be passed along to \code{\link{grepl}}.}
}
\value{
A character vector of country names that are complete or partial
 matches with any of the input country names.
}
\description{
Country names passed to the Comtrade API must have precise
spelling/capitalization. This is a helper function for querying the country
names/spelling used by Comtrade.. It takes as input a vector of
country names, output is any country names that contain any of the input
strings, using regex via the base function grepl.
For use with the UN Comtrade API, full API docs can be found at
\url{https://comtrade.un.org/data/doc/api/}
}
\details{
This function uses regular expressions (regex) to find matches
 within the country DB. This means it will treat as a match any country
 string that contains the input search term. For more on using regex
 within R, see
 \url{https://stat.ethz.ch/R-manual/R-devel/library/base/html/regex.html}
}
\examples{
# Look up all reporters that contain the terms "korea" and "vietnam"
ct_country_lookup(c("korea", "vietnam"), "reporter")
}
\seealso{
\code{\link{grepl}}
}
