% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ct_commodity_lookup}
\alias{ct_commodity_lookup}
\title{UN Comtrade commodities database query}
\usage{
ct_commodity_lookup(
  search_terms,
  return_code = FALSE,
  commodity_classification = "HS",
  type = "goods",
  return_char = FALSE,
  verbose = TRUE,
  ignore.case = TRUE,
  update = FALSE,
  ...
)
}
\arguments{
\item{search_terms}{Commodity names or commodity codes, as a char or numeric
vector.}

\item{return_code}{Logical, if set to FALSE, the function will return a
set of commodity descriptions along with commodity codes (as a single
string for each match found), if set to TRUE it will return only the
commodity codes. Default value is FALSE.}

\item{commodity_classification}{The trade classification scheme.
Possible values for goods: \code{c('HS','S1','S2','S3','S4','SS','B4','B5')};
for services: \code{c('EB02','EB10','EB10S','EB')}. Default: 'HS'.}

\item{type}{The type of returned trade data.
Possible values: 'goods' for trade in goods,
'services' for trade in services. Default: 'goods'.}

\item{return_char}{Logical, if set to FALSE, the function will return the
matches as a named list, if set to TRUE it will return them as a character
vector. Default value is FALSE.}

\item{verbose}{Logical, if set to TRUE, a warning message will print to
console if any of the elements of input "search_terms" returned no matches
(message will indicate which elements returned no data). Default is TRUE.}

\item{ignore.case}{logical, to be passed along to arg ignore.case within
\code{\link{grepl}}. Default value is TRUE.}

\item{update}{If TRUE, downloads possibly updated reference tables
from the UN. Default: FALSE.}

\item{...}{additional args to be passed along to \code{\link{grepl}}.}
}
\value{
A list or character vector of commodity descriptions and/or
commodity codes that are matches with the elements of "search_terms".
}
\description{
The Comtrade API requires that searches for specific commodities be done
using commodity codes. This is a helper function for querying the
Comtrade commodity database. It takes as input a vector of
commodities or commodity codes. Output is a list or vector of commodity
descriptions or codes associated with the input search_terms. For use with
the UN Comtrade API, full API docs can be found at
\url{https://unstats.un.org/wiki/display/comtrade/}
}
\details{
This function uses regular expressions (regex) to find matches
within the commodity DB. This means it will treat as a match any commodity
description that contains the input search term. For more on using regex
within R, see
\url{https://stat.ethz.ch/R-manual/R-devel/library/base/html/regex.html}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
comtradr::ct_commodity_lookup("wine")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link{grepl}}
}
