% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_error_cpa.R
\encoding{UTF-8}
\name{var_error_cpa}
\alias{var_error_cpa}
\title{Estimate the sampling error variance for criterion profile analysis parameters}
\usage{
var_error_cpa(Rxx, rxy, n, se_var_mat = "normal", adjust = c("fisher",
  "pop", "cv"))
}
\arguments{
\item{Rxx}{An intercorrelation matrix among the predictor variables}

\item{rxy}{A vector of predictor–criterion correlations}

\item{n}{The sample size}

\item{se_var_mat}{The method used to calculate the sampling covariance matrix for the unique elements of Rxx and rxy. Can be "normal" to estimate the covariance matrix using "n" or a matrix of sampling covariance values.}

\item{adjust}{Method to adjust R-squared for overfitting. See \code{\link{adjust_Rsq}} for details.}
}
\value{
A list containing sampling covariance matrices or sampling erorr variance estimates for CPA parameters
}
\description{
Estimate the sampling error variance for criterion profile analysis parameters
}
\examples{
\dontrun{
  var_error_cpa(mindful_rho[1:5, 1:5], mindful_rho[1:5, 6],
          n = 17060)
}
}
