% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_doc.R
\docType{data}
\encoding{UTF-8}
\name{gre}
\alias{gre}
\title{Meta-analytic correlations of Graduate Record Examination subtests with graduate grade point average}
\format{
list with entries \code{r} (mean observed correlations), \code{rho} (mean
corrected correlations), \code{n} (sample sizes), \code{sevar_r} (sampling error
variances for mean observed correlations), \code{sevar_rho} (sampling error
variances for mean corrected correlations), and \code{source} (character labels
indicating which meta-analytic correlations came from the same source)
}
\usage{
data(jobchar)
}
\description{
Correlations between GRE subtests and graduate student GPA from Kuncel et al. (2001).
}
\details{
GRE–GPA correlations in \code{rho} are corrected for direct range restriction on
the GRE and unreliability in GPA. Subtest intercorrelations in \code{rho} are
observed correlations computed among applicant norm samples. These values are
also used in \code{r}. Due to compensatory selection on GRE scores, these values
will not accurately reflect subtest intercorrelations in selected-student
(range-restricted) samples. \code{sevar_rho} and\code{sevar_r} for GRE subtest
intercorrelations are computed with an assumed
\if{latex}{\eqn{SD_\rho}}\ifelse{html}{\out{SD<sub>&rho;</sub>}}{SD_rho} = .02.
}
\examples{
data(gre)
}
\references{
Kuncel, N. R., Hezlett, S. A., & Ones, D. S. (2001).
A comprehensive meta-analysis of the predictive validity of the graduate record examinations: Implications for graduate student selection and performance.
\emph{Psychological Bulletin, 127}(1), 162–181. \doi{10.1037/0033-2909.127.1.162}
}
\keyword{datasets}
