% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/content.R
\name{content_update}
\alias{content_update}
\alias{content_update_access_type}
\alias{content_update_owner}
\title{Update Content}
\usage{
content_update(content, ...)

content_update_access_type(content, access_type = c("all", "logged_in", "acl"))

content_update_owner(content, owner_guid)
}
\arguments{
\item{content}{An R6 content item}

\item{...}{Settings up update that are passed along to Posit Connect}

\item{access_type}{One of "all", "logged_in", or "acl"}

\item{owner_guid}{The GUID of a user who is a publisher, so that they can
become the new owner of the content}
}
\value{
An R6 content item
}
\description{
Update settings for a content item. For a list of all settings, see the
\href{https://docs.posit.co/connect/api/#patch-/v1/content/{guid}}{latest documentation}
or the documentation for your server via \code{connectapi::browse_api_docs()}.
}
\details{
Popular selections are \code{content_update(access_type="all")},
\code{content_update(access_type="logged_in")} or
\code{content_update(access_type="acl")}, process settings, title, description,
etc.
\itemize{
\item \code{content_update_access_type()} is a helper to make it easier to change access_type
\item \code{content_update_owner()} is a helper to make it easier to change owner
}
}
\seealso{
Other content functions: 
\code{\link{acl_add_user}()},
\code{\link{content_delete}()},
\code{\link{content_item}()},
\code{\link{content_title}()},
\code{\link{create_random_name}()},
\code{\link{dashboard_url_chr}()},
\code{\link{dashboard_url}()},
\code{\link{delete_vanity_url}()},
\code{\link{deploy_repo}()},
\code{\link{get_acl_user}()},
\code{\link{get_bundles}()},
\code{\link{get_environment}()},
\code{\link{get_image}()},
\code{\link{get_jobs}()},
\code{\link{get_vanity_url}()},
\code{\link{git}},
\code{\link{permissions}},
\code{\link{set_image_path}()},
\code{\link{set_run_as}()},
\code{\link{set_vanity_url}()},
\code{\link{swap_vanity_url}()},
\code{\link{verify_content_name}()}
}
\concept{content functions}
